import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

public class Weltall extends World
{
    private Sonne unsereSonne;
    private Umlaufbahn mondUmlaufbahn; 
    private Erde unsereErde;
    private Mond unserMond;
    private Anzeige datumAnzeige, phasenAnzeige;
    private Monderscheinung unsereMonderscheinung;
    private Mondphase eineMondphase;
    private Pfeil meinPfeilRaufTag, meinPfeilRaufMonat,meinPfeilRaufJahr, meinPfeilRunterTag, meinPfeilRunterMonat, meinPfeilRunterJahr;

    private String datumString;
    private int mondphase;
    private String mondPhasenName, mondPhasenBild;

    public Weltall()
    {    
        super(1000, 600, 1);
        unsereSonne = new Sonne();
        mondUmlaufbahn = new Umlaufbahn();
        unsereErde = new Erde();
        unserMond = new Mond();
        datumAnzeige = new Anzeige(250, 50);
        phasenAnzeige = new Anzeige(400, 26);
        unsereMonderscheinung = new Monderscheinung();
        eineMondphase = new Mondphase(); 
        meinPfeilRaufTag = new Pfeil("TagRauf", "pfeilRauf.gif");
        meinPfeilRaufMonat = new Pfeil("MonatRauf", "pfeilRauf.gif");
        meinPfeilRaufJahr = new Pfeil("JahrRauf", "pfeilRauf.gif");
        meinPfeilRunterTag = new Pfeil("TagRunter", "pfeilRunter.gif");
        meinPfeilRunterMonat = new Pfeil("MonatRunter", "pfeilRunter.gif");
        meinPfeilRunterJahr = new Pfeil("JahrRunter", "pfeilRunter.gif");

        addObject(unsereSonne,100,300);
        addObject(mondUmlaufbahn, 700,300);
        addObject(unsereErde, 700,300);
        addObject(datumAnzeige, 270,150);
        addObject(phasenAnzeige, 350,530);
        addObject(meinPfeilRaufTag, 164,87);
        addObject(meinPfeilRaufMonat, 255,87);
        addObject(meinPfeilRaufJahr, 347,87);
        addObject(meinPfeilRunterTag, 164,202);
        addObject(meinPfeilRunterMonat, 255,202);
        addObject(meinPfeilRunterJahr, 347,202);
    }

    public void mondphaseErmitteln(String pDatumString)
    {
        datumString = pDatumString;
        mondphase = eineMondphase.berechneMondphase(datumString);
        mondphaseUebersetzen(mondphase);
        unsereMonderscheinung.setImage(mondPhasenBild);
        datumAnzeige.updateImage(datumString);
        phasenAnzeige.updateImage(mondPhasenName);
    }

    public void mondphaseUebersetzen(int pMondphase)
    {
        switch(pMondphase)
        {
            case 0:
            {
                setzeMond(455,300);
                mondPhasenName = "Neumond";
                mondPhasenBild = "neumond.jpg";
                break;
            }
            case 1:
            {
                setzeMond(531,480);
                mondPhasenName = "zunehmender Mond Sichelform";
                mondPhasenBild = "zunehmenderMondsichelfoermig.jpg";
                break;
            }
            case 2:
            {
                setzeMond(700,545);
                mondPhasenName = "zunehmender Halbmond";
                mondPhasenBild = "zunehmenderHalbmond.jpg";
                break;
            }
            case 3:
            {
                setzeMond(879,480);
                mondPhasenName = "zunehmender Mond Buckelform";
                mondPhasenBild = "zunehmenderMondbuckelfoermig.jpg";
                break;
            }
            case 4:
            {
                setzeMond(945,300);
                mondPhasenName = "Vollmond";
                mondPhasenBild = "vollmond.jpg";
                break;
            }
            case 5:
            {
                setzeMond(879,135);
                mondPhasenName = "abnehmender Mond Buckelform";
                mondPhasenBild = "abnehmenderMondbuckelfoermig.jpg";                        
                break;
            }
            case 6:
            {
                setzeMond(700,55);
                mondPhasenName = "abnehmender Halbmond";
                mondPhasenBild = "abnehmenderHalbmond.jpg";
                break;
            }
            case 7:
            {
                setzeMond(531,135);
                mondPhasenName = "abnehmender Mond Sichelform";
                mondPhasenBild = "abnehmenderMondsichelfoermig.jpg";
                break;
            }
        }
    }

    public void setzeMond(int pX, int pY)
    {
        removeObject(unserMond);
        addObject(unserMond,pX, pY);
        addObject(unsereMonderscheinung, 250, 300);
    }

    public String getDatumString()
    {
        return datumString;
    }

    public String sucheDatumEinerMondphase(String pDatumString, int pKlickMondphase)
    {
        return eineMondphase.sucheMondphasenDatum(pDatumString, pKlickMondphase);
    }

    public String getMondphasenName()
    {
        return mondPhasenName;
    }

    public void schreibeAnzeige(String pDatumString, String pText)
    {
        datumString = pDatumString;
        datumAnzeige.updateImage(datumString);
        phasenAnzeige.updateImage(pText);
    }

    public void aendereMonderscheinung()
    {
        unsereMonderscheinung.setImage(mondPhasenBild);
    }
}
