package paketSprit;

import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.List;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;


public class Hauptfenster extends JFrame
{

	private static final long serialVersionUID = 1L;
	private JPanel contentPane;
	private JTextField tfKMStandAlt;
	private JTextField tfKMStandNeu;
	private JTextField tfGetankteLiter;
	private JTextField tfGesamtpreis;
	private JTextField tfVerbrauchJe100km;
	private JTextField tfKostenJe100km;
	private JTextField tfGefahreneKM;
	private JTextField tfBewertung;
	private Sprit meinSprit = new Sprit();
	private List lfListe;
	private DecimalFormat dfEuro = new DecimalFormat("#,##0.00 ");
	
	public static void main(String[] args)
	{
		EventQueue.invokeLater(new Runnable()
		{
			public void run()
			{
				try
				{
					Hauptfenster frame = new Hauptfenster();
					frame.setVisible(true);
				} catch (Exception e)
				{
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public Hauptfenster()
	{
		
		setTitle("Spritkostenrechner");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 736, 325);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);

		JLabel lblKmStand = new JLabel("KM - Stand Alt:");
		lblKmStand.setBounds(10, 28, 102, 14);
		contentPane.add(lblKmStand);

		JLabel lblKmStand_1 = new JLabel("KM - Stand Neu: ");
		lblKmStand_1.setBounds(10, 53, 102, 14);
		contentPane.add(lblKmStand_1);

		JLabel lblGetankteLiter = new JLabel("Getankte Liter:");
		lblGetankteLiter.setBounds(10, 88, 102, 14);
		contentPane.add(lblGetankteLiter);

		JLabel lblGesamtpreis = new JLabel("Gesamtpreis: ");
		lblGesamtpreis.setBounds(10, 116, 102, 14);
		contentPane.add(lblGesamtpreis);

		tfKMStandAlt = new JTextField();
		tfKMStandAlt.setBounds(121, 25, 86, 20);
		contentPane.add(tfKMStandAlt);
		tfKMStandAlt.setColumns(10);

		tfKMStandNeu = new JTextField();
		tfKMStandNeu.setBounds(121, 53, 86, 20);
		contentPane.add(tfKMStandNeu);
		tfKMStandNeu.setColumns(10);

		tfGetankteLiter = new JTextField();
		tfGetankteLiter.setBounds(121, 85, 86, 20);
		contentPane.add(tfGetankteLiter);
		tfGetankteLiter.setColumns(10);

		tfGesamtpreis = new JTextField();
		tfGesamtpreis.setBounds(121, 113, 86, 20);
		contentPane.add(tfGesamtpreis);
		tfGesamtpreis.setColumns(10);

		JButton btBerechnen = new JButton("Berechnen");
		btBerechnen.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				meinSprit.setKmStandAlt(Double.parseDouble(tfKMStandAlt
						.getText()));
				meinSprit.setKmStandNeu(Double.parseDouble(tfKMStandNeu
						.getText()));
				meinSprit.setGetankteLiter(Double.parseDouble(tfGetankteLiter
						.getText()));
				meinSprit.setGesamtPreis(Double.parseDouble(tfGesamtpreis
						.getText()));
				meinSprit.berechne();
				meinSprit.bewertung();
				tfGefahreneKM.setText(Double.toString(meinSprit
						.getGefahreneKM()));
				tfVerbrauchJe100km.setText(Double.toString(meinSprit
						.getVerbrauchJe100km()));
				tfKostenJe100km.setText(dfEuro.format(meinSprit
						.getKostenJe100km()));
				tfBewertung.setText(meinSprit.getBewertung());
				listefuellen();

			}
		});
		btBerechnen.setBounds(10, 136, 197, 23);
		contentPane.add(btBerechnen);

		JLabel lblVerbrauchteLiterAuf = new JLabel(
				"Verbrauchte Liter auf 100 km: ");
		lblVerbrauchteLiterAuf.setBounds(10, 195, 157, 14);
		contentPane.add(lblVerbrauchteLiterAuf);

		JLabel lblNewLabel = new JLabel("Spritkosten je 100 km:");
		lblNewLabel.setBounds(10, 220, 177, 14);
		contentPane.add(lblNewLabel);

		tfVerbrauchJe100km = new JTextField();
		tfVerbrauchJe100km.setBounds(185, 192, 86, 20);
		contentPane.add(tfVerbrauchJe100km);
		tfVerbrauchJe100km.setColumns(10);

		tfKostenJe100km = new JTextField();
		tfKostenJe100km.setBounds(185, 217, 86, 20);
		contentPane.add(tfKostenJe100km);
		tfKostenJe100km.setColumns(10);

		JLabel lblNewLabel_1 = new JLabel("Gefahrene km:");
		lblNewLabel_1.setBounds(10, 170, 157, 14);
		contentPane.add(lblNewLabel_1);

		tfGefahreneKM = new JTextField();
		tfGefahreneKM.setBounds(185, 167, 86, 20);
		contentPane.add(tfGefahreneKM);
		tfGefahreneKM.setColumns(10);

		JLabel lblNewLabel_2 = new JLabel("Bewertung:");
		lblNewLabel_2.setBounds(10, 250, 157, 14);
		contentPane.add(lblNewLabel_2);

		tfBewertung = new JTextField();
		tfBewertung.setBounds(185, 250, 212, 20);
		contentPane.add(tfBewertung);
		tfBewertung.setColumns(10);

		lfListe = new List();
		lfListe.setBounds(433, 7, 277, 264);
		contentPane.add(lfListe);
	}

	public void listefuellen()
	{
		lfListe.removeAll();
		for (int km = 100; km < 1000; km = km + 100)
		{
			lfListe.add(km + " km  kosten " + dfEuro.format(meinSprit.getKostenJe100km() * km
					/ 100 ));
		}
	}
}
