-- MySQL dump 10.16  Distrib 10.1.28-MariaDB, for Win32 (AMD64)
--
-- Host: localhost    Database: haro
-- ------------------------------------------------------
-- Server version	10.1.28-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `haro`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `haro` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci */;

USE `haro`;

--
-- Table structure for table `artikel`
--

DROP TABLE IF EXISTS `artikel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `artikel` (
  `artikelnr` varchar(5) NOT NULL,
  `bezeichnung` varchar(50) DEFAULT NULL,
  `wgnr` varchar(1) DEFAULT NULL,
  `teileartnr` varchar(1) DEFAULT NULL,
  `ekpreis` double DEFAULT NULL,
  `vkpreis` double DEFAULT NULL,
  `bestand` int(11) DEFAULT NULL,
  `meldebest` int(11) DEFAULT NULL,
  `aktiv` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`artikelnr`),
  KEY `FK_artikel_1` (`wgnr`),
  KEY `FK_artikel_2` (`teileartnr`),
  CONSTRAINT `FK_artikel_1` FOREIGN KEY (`wgnr`) REFERENCES `warengruppen` (`wgnr`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `FK_artikel_2` FOREIGN KEY (`teileartnr`) REFERENCES `teilearten` (`teileartnr`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `artikel`
--

LOCK TABLES `artikel` WRITE;
/*!40000 ALTER TABLE `artikel` DISABLE KEYS */;
INSERT INTO `artikel` VALUES ('10004','Handlupe 90 mm','4','E',9.59,18.221,300,200,0),('10005','Lupe 90 mm','4','E',4.5,8.55,1010,500,0),('10028','Abgleichschraubendreher-Satz','2','E',12.95,24.605,680,300,0),('10030','Schraubendreher: 1,5 mm ','2','E',1,1.9,290,200,0),('10031','Schraubendreher: 1,8 mm','2','E',1,1.9,220,200,0),('10034','Schraubendreher: 3,0 mm ','2','E',1,1.9,300,200,0),('10044','Stahllaubsäge ','3','E',5.45,10.355,1250,400,0),('10049','Laubsägeblätter (12er Set)','3','E',2.35,4.465,2400,600,0),('10050','Universal-Hobby-Säge','3','E',5.95,11.305,1350,200,0),('10056','Isolier-Abstreifzängleinchen','1','E',13.57,19.95,2400,250,0),('10057','Adernendhülsen-Zängle','1','E',16.5,31.35,1750,220,0),('10058','Universal-Kabelzange','1','E',6.45,12.255,1900,300,0),('10059','Schraubendreher-Set','2','E',11.2,21.28,1800,180,0),('10062','Pozidriv-Schraubendreher','2','E',2.8,5.32,2850,200,0),('10068','Elektronik-Seitenschneider','1','H',3.65,6.935,750,150,0),('10069','Elektronik-Flachzange','1','H',3.65,6.935,2800,250,0),('10070','Elektronik-Halbrundzange','1','H',3.65,6.935,1950,500,0),('10071','Loch- und Ösenzange','1','E',12.95,24.605,2540,350,0),('10075','Edelstahlzange flach','1','H',6.5,12.35,150,300,0),('10076','Automatik-Abisolierzange','1','H',4.95,9.405,100,250,0),('10080','Telefonzange 200 mm','1','H',5.9,11.21,1950,200,0),('10081','Mehrzweckzange','1','H',18.5,35.15,4500,200,0),('10086','Multifunktions-Crimpzange','1','E',39.5,75.05,1150,150,0),('11058','Spezial-Bauschubkarren','4','E',59.9,113.81,450,250,0),('11062','Durchwurfsieb verzinkt 100x60 cm','4','E',39.9,75.81,550,250,0),('70001','Werkzeugkasten Universal','4','E',149,283.1,120,50,0),('71001','Schlagbohrmaschine','4','H',63,119.7,155,50,0),('71002','Bohrersatz für Holz/Metall/Stein','4','H',3.5,6.65,135,50,0),('71003','Bit-Steckschlüsselsatz','4','H',3.2,6.08,124,50,0),('71004','Schlosserhammer','4','H',3.5,6.65,90,80,0),('72102','Wasserpumpenzange 240','1','E',3.65,6.935,122,20,0),('72250','Wasserwaage 400 mm','4','H',4.4,8.36,90,40,0),('72255','Universalsäge','3','E',5.2,9.88,95,40,0),('72256','Sägeblatt Holz','3','H',0.55,1.045,124,40,0),('72257','Sägeblatt Metall','3','H',1.5,2.85,132,40,0),('74001','Kasten 75/45','4','E',6.9,13.11,105,50,0);
/*!40000 ALTER TABLE `artikel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auftragskoepfe`
--

DROP TABLE IF EXISTS `auftragskoepfe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auftragskoepfe` (
  `aufnr` varchar(5) NOT NULL DEFAULT '0',
  `aufdat` date DEFAULT NULL,
  `kdnr` varchar(5) DEFAULT NULL,
  `auftermin` date DEFAULT NULL,
  `gebucht` tinyint(4) NOT NULL,
  PRIMARY KEY (`aufnr`),
  KEY `FK_auftragskoepfe_1` (`kdnr`),
  CONSTRAINT `FK_auftragskoepfe_1` FOREIGN KEY (`kdnr`) REFERENCES `kunden` (`kdnr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auftragskoepfe`
--

LOCK TABLES `auftragskoepfe` WRITE;
/*!40000 ALTER TABLE `auftragskoepfe` DISABLE KEYS */;
INSERT INTO `auftragskoepfe` VALUES ('22334','2009-01-26','24001','2009-02-18',0),('22335','2009-01-27','24004','2009-02-27',0),('22336','2009-01-31','24003','2009-03-02',0),('22337','2009-02-12','24005','2009-03-11',0);
/*!40000 ALTER TABLE `auftragskoepfe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `auftragspositionen`
--

DROP TABLE IF EXISTS `auftragspositionen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auftragspositionen` (
  `aufposnr` varchar(5) NOT NULL,
  `aufnr` varchar(5) NOT NULL,
  `artikelnr` varchar(5) DEFAULT NULL,
  `aufmenge` int(11) DEFAULT NULL,
  PRIMARY KEY (`aufposnr`),
  KEY `FK_auftragspositionen_1` (`aufnr`),
  KEY `FK_auftragspositionen_2` (`artikelnr`),
  CONSTRAINT `FK_auftragspositionen_1` FOREIGN KEY (`aufnr`) REFERENCES `auftragskoepfe` (`aufnr`),
  CONSTRAINT `FK_auftragspositionen_2` FOREIGN KEY (`artikelnr`) REFERENCES `artikel` (`artikelnr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `auftragspositionen`
--

LOCK TABLES `auftragspositionen` WRITE;
/*!40000 ALTER TABLE `auftragspositionen` DISABLE KEYS */;
INSERT INTO `auftragspositionen` VALUES ('1','22334','10004',20),('2','22334','10030',3),('3','22335','10005',15),('4','22335','10056',10),('5','22335','10059',35),('6','22336','10004',40),('7','22337','10069',5),('8','22337','10070',5);
/*!40000 ALTER TABLE `auftragspositionen` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kunden`
--

DROP TABLE IF EXISTS `kunden`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kunden` (
  `kdnr` varchar(5) NOT NULL,
  `name` varchar(50) DEFAULT NULL,
  `strasse` varchar(50) DEFAULT NULL,
  `plz` varchar(5) DEFAULT NULL,
  `ort` varchar(50) DEFAULT NULL,
  `passwort` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`kdnr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kunden`
--

LOCK TABLES `kunden` WRITE;
/*!40000 ALTER TABLE `kunden` DISABLE KEYS */;
INSERT INTO `kunden` VALUES ('24001','Baumarkt Müller','Postfach 134','85579','Neubiberg','12345'),('24002','Friedrich Kunst','Mausweg 24','72510','Stetten a.k.M.','23456'),('24003','BAU MIT  GmbH','Im Grund 11','86657','Bissingen','34567'),('24004','Otto Weber','Postfach 888','78727','Oberndorf a.N.','45678'),('24005','Peter Helferich','Stuttgarter Str. 44','75394','Oberreichenbach','56789'),('24006','Bau und Ausbau GmbH','Postfach 8573','71106','Magstadt','98765'),('24007','Hahn & Widmann','Postfach 2112','72336','Balingen','87654'),('24008','Otto Huber','Kaiserstr. 33','78224','Singen','11111'),('24013','TOOM-Baumarkt','Im Lehen 20','78315','Radolfzell',NULL);
/*!40000 ALTER TABLE `kunden` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `lieferer`
--

DROP TABLE IF EXISTS `lieferer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `lieferer` (
  `liefnr` varchar(5) NOT NULL,
  `name` varchar(25) DEFAULT NULL,
  `plz` varchar(5) DEFAULT NULL,
  `strasse` varchar(20) DEFAULT NULL,
  `ort` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`liefnr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `lieferer`
--

LOCK TABLES `lieferer` WRITE;
/*!40000 ALTER TABLE `lieferer` DISABLE KEYS */;
INSERT INTO `lieferer` VALUES ('44001','Friedrich Walter AG','72072','Mühlstr. 8','Tübingen'),('44002','Kugler und Grauer ','70173','Königstr. 13','Stuttgart'),('44003','Jonas Brauer GmbH','72766','Hagenweg 12','Reutlingen'),('44004','Ulmer Metallbau GmbH','72108','Am Marktplatz 1','Rottenburg'),('44005','Georg Liebherr und Söhne','72070','Goethestr. 5','Tübingen'),('44006','Kaiser & Franz OHG','72108','Dorfstr. 1','Rottenburg'),('44007','Weinmann GmbH','72379','Fliederstr. 35','Hechingen'),('44008','Grauer Metallfärserei KG','72622','Brunnenstr. 56','Nürtingen'),('44009','Richard Vollmer & Co KG','72766','Leharweg 13','Reutlingen'),('44010','Wiedmeier & Söhne','76532','Industriestraße 34','Rastatt'),('44011','Lidl GmbH','72760','Goethestr. 13','Reutlingen');
/*!40000 ALTER TABLE `lieferer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `liefermoeglichkeiten`
--

DROP TABLE IF EXISTS `liefermoeglichkeiten`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `liefermoeglichkeiten` (
  `liefnr` varchar(5) NOT NULL,
  `artikelnr` varchar(5) NOT NULL,
  `preis` double(7,2) DEFAULT NULL,
  PRIMARY KEY (`liefnr`,`artikelnr`),
  KEY `FK_liefermoeglichkeiten_1` (`liefnr`),
  KEY `FK_liefermoeglichkeiten_2` (`artikelnr`),
  CONSTRAINT `FK_liefermoeglichkeiten_1` FOREIGN KEY (`liefnr`) REFERENCES `lieferer` (`liefnr`),
  CONSTRAINT `FK_liefermoeglichkeiten_2` FOREIGN KEY (`artikelnr`) REFERENCES `artikel` (`artikelnr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `liefermoeglichkeiten`
--

LOCK TABLES `liefermoeglichkeiten` WRITE;
/*!40000 ALTER TABLE `liefermoeglichkeiten` DISABLE KEYS */;
INSERT INTO `liefermoeglichkeiten` VALUES ('44001','10004',20.00),('44001','10005',8.55),('44001','10028',12.95),('44001','10050',11.31),('44001','10056',19.95),('44002','10044',5.15),('44003','10049',4.90),('44004','10056',19.95),('44005','10005',3.20),('44006','10004',20.00),('44006','10049',4.99),('44006','10056',19.95);
/*!40000 ALTER TABLE `liefermoeglichkeiten` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `teilearten`
--

DROP TABLE IF EXISTS `teilearten`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `teilearten` (
  `teileartnr` varchar(1) NOT NULL,
  `teileart` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`teileartnr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `teilearten`
--

LOCK TABLES `teilearten` WRITE;
/*!40000 ALTER TABLE `teilearten` DISABLE KEYS */;
INSERT INTO `teilearten` VALUES ('E','Erzeugnis'),('H','Handelsware'),('R','Rohstoff'),('T','Einzelteil');
/*!40000 ALTER TABLE `teilearten` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `warengruppen`
--

DROP TABLE IF EXISTS `warengruppen`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `warengruppen` (
  `wgnr` varchar(1) NOT NULL,
  `warengruppe` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`wgnr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `warengruppen`
--

LOCK TABLES `warengruppen` WRITE;
/*!40000 ALTER TABLE `warengruppen` DISABLE KEYS */;
INSERT INTO `warengruppen` VALUES ('1','Zangen'),('2','Schraubendreher'),('3','Sägen'),('4','Sonstige Artikel');
/*!40000 ALTER TABLE `warengruppen` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2018-03-03 17:28:49
