import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)
import java.util.GregorianCalendar;
import java.util.Calendar;
import java.text.DecimalFormat;

public class Mondphase extends Actor
{ private int mondPhase;          
    private int jahrhunderNummer;          
    private int mondalter1Januar;        
    private int tagesNummer;          
    private int goldeneMondNummer;        
    private int tagNummer_imJahr[] = { -1, -1, 30, 58, 89, 119, 150, 180, 211, 241, 272, 303, 333 };
    private int startTag, startMonat, startJahr;
    private boolean datumOK;
    private String datumString;
    private DecimalFormat dfZweistellig = new DecimalFormat("##00"); 

    public void act() 
    {} 

    public int  berechneMondphase(String pDatumString)
    {
        if (istDatumGueltig(pDatumString) == true)
        {
            if (startMonat < 0 || startMonat > 12)
            {
                startMonat = 0;
            }
            tagesNummer = startTag + tagNummer_imJahr[startMonat];  

            if ((startMonat > 2) && this.istSchaltjahrPruefen(startJahr)) 
            {
                tagesNummer++;                                  
            }
            jahrhunderNummer = (startJahr / 100) + 1;                    
            goldeneMondNummer = (startJahr % 19) + 1;                   
            mondalter1Januar = ((11 * goldeneMondNummer) + 20 + (((8 * jahrhunderNummer) + 5) / 25) - 5 - (((3 * jahrhunderNummer) / 4) - 12)) % 30;    
            if (mondalter1Januar <= 0)
            {
                mondalter1Januar += 30; 
            }
            if ((mondalter1Januar == 25 && goldeneMondNummer > 11) || mondalter1Januar == 24)
            {
                mondalter1Januar++;
            }       
            mondPhase = (((((tagesNummer + mondalter1Januar) * 6) + 11) % 177) / 22) & 7;
        }
        else
        {
            mondPhase = -1;
        }    
        return(mondPhase);
    }

    public  boolean istSchaltjahrPruefen(int pJahr) 
    {
        return ((pJahr % 4 == 0) && ((pJahr % 400 == 0) || (pJahr % 100 != 0)));
    }

    public boolean istDatumGueltig(String pDatumString)
    {
        datumOK = false;
        try
        {
            startTag = Integer.parseInt(pDatumString.substring(0,2));
            startMonat = Integer.parseInt(pDatumString.substring(3,5));
            startJahr = Integer.parseInt(pDatumString.substring(6,10));
            datumOK = true;
        }
        catch (Exception e) 
        {
            datumOK = false;
        }

        if (datumOK == true)
        {
            datumOK = false;
            GregorianCalendar gc = new GregorianCalendar(startJahr,startMonat-1,startTag);  
            gc.setLenient(false);
            try 
            {
                gc.get(GregorianCalendar.YEAR);
                gc.get(GregorianCalendar.MONTH);
                gc.get(GregorianCalendar.DAY_OF_MONTH);
                datumOK = true;
            } 
            catch (Exception e) 
            {
                datumOK = false;
            }
        }
        return datumOK;
    } 

    public String sucheMondphasenDatum(String pDatumString, int pSuchMondphase)
    {
        if (istDatumGueltig(pDatumString) == true)
        {
            GregorianCalendar neuesDatum = new GregorianCalendar();
            while (pSuchMondphase != mondPhase)
            {
                neuesDatum.set(Calendar.DATE, startTag);
                neuesDatum.set(Calendar.MONTH, startMonat - 1);
                neuesDatum.set(Calendar.YEAR, startJahr);
                if (pSuchMondphase >= mondPhase)
                {
                    neuesDatum.add(Calendar.DAY_OF_YEAR, 1);
                }
                if (pSuchMondphase < mondPhase)
                {
                    neuesDatum.add(Calendar.DAY_OF_YEAR, -1);
                }
                startTag = neuesDatum.get(Calendar.DATE);
                startMonat = neuesDatum.get(Calendar.MONTH) + 1;
                startJahr = neuesDatum.get(Calendar.YEAR);
                datumString = dfZweistellig.format(startTag) + "." + dfZweistellig.format(startMonat) + "." + startJahr;
                berechneMondphase(datumString);
            }
        }
        return datumString;
    }
    
}


