import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)
import java.text.DecimalFormat;
import java.util.GregorianCalendar;

public class Pfeil extends Actor
{
    private String pfeilName, datumString;
    private int startTag, startMonat, startJahr;
    private DecimalFormat dfZweistellig = new DecimalFormat("##00"); 
    private boolean datumOK;
    
    
    public Pfeil(String pPfeilName, String pBildname )
    {
        pfeilName = pPfeilName;
        setImage(pBildname);
    }      

    public void act() 
    {
        if (Greenfoot.mouseClicked(this))
        {
            datumString = ((Weltall)getWorld()).getDatumString();
            startTag = Integer.parseInt(datumString.substring(0,2));
            startMonat = Integer.parseInt(datumString.substring(3,5));
            startJahr = Integer.parseInt(datumString.substring(6,10));

            if(pfeilName.equals("TagRauf"))
            {
                startTag = startTag + 1;
            }
            if(pfeilName.equals("MonatRauf"))
            {
                startMonat = startMonat + 1;
            }
            if(pfeilName.equals("JahrRauf"))
            {
                startJahr = startJahr + 1;
            }
            if(pfeilName.equals("TagRunter"))
            {
                startTag = startTag - 1;
            }
            if(pfeilName.equals("MonatRunter"))
            {
                startMonat = startMonat - 1;
            }
            if(pfeilName.equals("JahrRunter"))
            {
                startJahr = startJahr - 1;
            }

            datumString = dfZweistellig.format(startTag) + "." + dfZweistellig.format(startMonat) + "." + startJahr;

            if (istDatumGueltig()== true)
            {
                ((Weltall)getWorld()).mondphaseErmitteln(datumString);
            }
            else
            {
                datumString = ((Weltall)getWorld()).getDatumString();
            }

        }
        
    } 
    
    public boolean istDatumGueltig()
    {
        datumOK = true;
        GregorianCalendar gc = new GregorianCalendar(startJahr,startMonat-1,startTag);  
        gc.setLenient(false);
        try {
            gc.get(GregorianCalendar.YEAR);
            gc.get(GregorianCalendar.MONTH);
            gc.get(GregorianCalendar.DAY_OF_MONTH);
        } 
        catch (Exception e) 
        {
            datumOK = false;
        }
        return datumOK;
    } 
}
