package paketArtikelMitGUIundOODB;

import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;

import paketArtikelMitGUIundOODB.Artikel;

import java.awt.Rectangle;

public class Hauptfenster extends JFrame {

	private static final long serialVersionUID = 1L;
    private Artikel meinArtikel;
	private DBZugriff meinZugriff;
    
	private JPanel jContentPane = null;
	private JLabel jLabel = null;
	private JLabel jLabel1 = null;
	private JLabel jLabel2 = null;
	private JLabel jLabel3 = null;
	private JTextField tfArtikelNr = null;
	private JTextField tfBezeichnung = null;
	private JTextField tfPreis = null;
	private JButton btMehren = null;
	private JButton btLeeren = null;
	private JButton btAenderungenSpeichern = null;
	private JButton btSuchen = null;
	private JButton btEnde = null;

	private JLabel jLabel4 = null;

	private JLabel lbBestand = null;

	private JTextField tfBewegung = null;

	private JButton btMindern = null;
	private JButton btNeuerArtikelSpeichern = null;

	public Hauptfenster()
	{
		super();
		initialize();
		meinArtikel = new Artikel();
		meinZugriff=new DBZugriff();
		//meinZugriff.oeffneDB();
				
	}

	private void initialize()
	{
		this.setSize(424, 395);
		this.setContentPane(getJContentPane());
		this.setTitle("Artikelverwaltung mit OODB");
	}

	private JPanel getJContentPane()
	{
		if (jContentPane == null)
		{	lbBestand = new JLabel();
			lbBestand.setBounds(new java.awt.Rectangle(150,110,100,25));
			lbBestand.setText("");
			
			jLabel4 = new JLabel();
			jLabel4.setBounds(new java.awt.Rectangle(20,110,120,25));
			jLabel4.setText("Bestand");
			
			jLabel3 = new JLabel();
			jLabel3.setBounds(new java.awt.Rectangle(20,160,120,25));
			jLabel3.setText("Bestandsbewegung:");
			
			jLabel2 = new JLabel();
			jLabel2.setBounds(new java.awt.Rectangle(20,80,120,25));
			jLabel2.setText("Preis:");
			
			jLabel1 = new JLabel();
			jLabel1.setBounds(new java.awt.Rectangle(20,50,120,25));
			jLabel1.setText("Bezeichnung:");
			
			jLabel = new JLabel();
			jLabel.setBounds(new java.awt.Rectangle(20,20,120,25));
			jLabel.setText("Artikelnummer");
			
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(jLabel, null);
			jContentPane.add(jLabel1, null);
			jContentPane.add(jLabel2, null);
			jContentPane.add(jLabel3, null);
			jContentPane.add(getTfArtikelNr(), null);
			jContentPane.add(getTfBezeichnung(), null);
			jContentPane.add(getTfPreis(), null);
			jContentPane.add(getBtMehren(), null);
			jContentPane.add(getBtLeeren(), null);
			jContentPane.add(getBtAenderungenSpeichern(), null);
			jContentPane.add(getBtSuchen(), null);
			jContentPane.add(getBtEnde(), null);
			jContentPane.add(jLabel4, null);
			jContentPane.add(lbBestand, null);
			jContentPane.add(getTfBewegung(), null);
			jContentPane.add(getBtMindern(), null);
			jContentPane.add(getBtNeuerArtikelSpeichern(), null);
		}
		return jContentPane;
	}

	private JTextField getTfArtikelNr()
	{	if (tfArtikelNr == null)
		{	tfArtikelNr = new JTextField();
			tfArtikelNr.setBounds(new java.awt.Rectangle(150,20,100,25));
			tfArtikelNr.setText("");
		}
		return tfArtikelNr;
	}

	private JTextField getTfBezeichnung()
	{
		if (tfBezeichnung == null)
		{
			tfBezeichnung = new JTextField();
			tfBezeichnung.setBounds(new java.awt.Rectangle(150,50,150,25));
		}
		return tfBezeichnung;
	}

	private JTextField getTfPreis()
	{
		if (tfPreis == null)
		{
			tfPreis = new JTextField();
			tfPreis.setBounds(new java.awt.Rectangle(150,80,100,25));
		}
		return tfPreis;
	}

	private JButton getBtMehren()
	{
		if (btMehren == null)
		{
			btMehren = new JButton();
			btMehren.setBounds(new Rectangle(281, 141, 120, 30));
			btMehren.setText("Mehren");
			btMehren.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{	meinArtikel.mehren(Integer.parseInt(tfBewegung.getText()));
					anzeigen();	
					
				}
			});
		}
		return btMehren;
	}

	private JButton getBtLeeren()
	{
		if (btLeeren == null)
		{
			btLeeren = new JButton();
			btLeeren.setBounds(new java.awt.Rectangle(20,225,120,30));
			btLeeren.setText("Felder leeren");
			btLeeren.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{	/*tfArtikelNr.setText("");
					tfBezeichnung.setText("");
					tfBewegung.setText("");
					tfPreis.setText("");
					lbBestand.setText("");
					*/
					leeren();
				}
			});
		}
		return btLeeren;
	}

	private JButton getBtAenderungenSpeichern()
	{
		if (btAenderungenSpeichern == null)
		{
			btAenderungenSpeichern = new JButton();
			btAenderungenSpeichern.setBounds(new Rectangle(150, 225, 252, 30));
			btAenderungenSpeichern.setText("nderungen speichern");
			btAenderungenSpeichern.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{	meinArtikel.setArtikelNr(tfArtikelNr.getText());
					meinArtikel.setBezeichnung(tfBezeichnung.getText());
					meinArtikel.setPreis(Double.parseDouble(tfPreis.getText()));
					meinZugriff.schreibeObjekt(meinArtikel);
				}
			});
		}
		return btAenderungenSpeichern;
	}

	private JButton getBtSuchen()
	{
		if (btSuchen == null)
		{
			btSuchen = new JButton();
			btSuchen.setBounds(new java.awt.Rectangle(20,265,120,30));
			btSuchen.setText("Suchen");
			btSuchen.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					meinArtikel = meinZugriff.leseObjekt(tfArtikelNr.getText());
					if (meinArtikel == null)
					{
					JOptionPane.showMessageDialog(null, "Falsche Artikelnummer!");
					leeren();
					} 
					else
					{
						anzeigen();
					}
				}
			});
		}
		return btSuchen;
	}

	private JButton getBtEnde()
	{
		if (btEnde == null)
		{
			btEnde = new JButton();
			btEnde.setBounds(new Rectangle(21, 307, 120, 30));
			btEnde.setText("Beenden");
			btEnde.addActionListener(new java.awt.event.ActionListener()
			{
				public void actionPerformed(java.awt.event.ActionEvent e)
				{
					meinZugriff.schliesseDB();
					System.exit(0);
				}
			});
		}
		return btEnde;
	}

	private JTextField getTfBewegung()
	{
		if (tfBewegung == null)
		{
			tfBewegung = new JTextField();
			tfBewegung.setBounds(new java.awt.Rectangle(150,160,100,25));
		}
		return tfBewegung;
	}
    public void leeren()
    {
    	tfArtikelNr.setText("");
    	tfBezeichnung.setText("");
    	tfBewegung.setText("");
    	tfPreis.setText("");
    	lbBestand.setText("");

    	
    }
	public void anzeigen()
	{	tfArtikelNr.setText(meinArtikel.getArtikelNr());
		tfBezeichnung.setText(meinArtikel.getBezeichnung());
		//tfPreis.setText(String.valueOf(meinArtikel.getPreis()));
		tfPreis.setText(Double.toString(meinArtikel.getPreis()));
		lbBestand.setText(String.valueOf(meinArtikel.getBestand()));
	}

	/**
	 * This method initializes btMindern	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtMindern() {
		if (btMindern == null) {
			btMindern = new JButton();
			btMindern.setBounds(new Rectangle(282, 180, 120, 30));
			btMindern.setText("Mindern");
			btMindern.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					boolean mOK = true;
					mOK = meinArtikel.mindern(Integer.parseInt(tfBewegung.getText()));
					if (mOK)
					{
						anzeigen();	
					}
					else
					{
						JOptionPane.showMessageDialog(null, "Der Lagerbestand ist zu klein!");
					}
				}
			});
		}
		return btMindern;
	}

	/**
	 * This method initializes btNeuerArtikelSpeichern	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtNeuerArtikelSpeichern() {
		if (btNeuerArtikelSpeichern == null) {
			btNeuerArtikelSpeichern = new JButton();
			btNeuerArtikelSpeichern.setBounds(new Rectangle(150, 267, 250, 29));
			btNeuerArtikelSpeichern.setText("Als neuer Artikel speichern");
			btNeuerArtikelSpeichern.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) 
				{
				    Artikel meinNeuerArtikel = new Artikel(); 
					meinNeuerArtikel.setArtikelNr(tfArtikelNr.getText());
					meinNeuerArtikel.setBezeichnung(tfBezeichnung.getText());
					meinNeuerArtikel.setPreis(Double.parseDouble(tfPreis.getText()));
					meinZugriff.schreibeObjekt(meinNeuerArtikel);
				}
			});
		}
		return btNeuerArtikelSpeichern;
	}
}
