import java.io.*;
import com.db4o.*;
import com.db4o.config.*;
import com.db4o.reflect.jdk.*;

public class Artikelverwaltung
{ 
    private String db4oDatenbankname = "datenbank.yap";
    private ObjectContainer dbVerbindung; 
    private Artikel vergleichsArtikel;
    private Artikel gefundenerArtikel;

    public Artikelverwaltung()
    {
    }

    public void neueDatenbankAnlegen()
    {
        new File(db4oDatenbankname).delete();
        dbVerbindung = Db4o.openFile(db4oDatenbankname);
        dbVerbindung.close();
    }

    public void datenbankOeffnen()
    {
        // Neue Codeierung erforderlich da die neuen BlueJ Versionen an 3.04 mit einem genderten Classloader arbeiten!
        Thread.currentThread().setContextClassLoader(Artikelverwaltung.class.getClassLoader());
        Configuration configuration = Db4o.configure();
        configuration.reflectWith(new JdkReflector(Thread.currentThread().getContextClassLoader()));      
        dbVerbindung = Db4o.openFile(db4oDatenbankname);
    }

    public void speichereNeuenArtikel(Artikel pArtikel)
    {  
        dbVerbindung = Db4o.openFile(db4oDatenbankname);
        dbVerbindung.store(pArtikel);
        dbVerbindung.close();
    }

    public void zeigeAlleGespeichertenArtikel()
    { 
        datenbankOeffnen();
        vergleichsArtikel = new Artikel(null, null, 0, 0);
        ObjectSet abfrageErgebnis = dbVerbindung.queryByExample(vergleichsArtikel);
        while(abfrageErgebnis.hasNext()) 
        {
            gefundenerArtikel = (Artikel) abfrageErgebnis.next();
            System.out.println("Nr: " + gefundenerArtikel.getArtikelNr() +  " Bez: " + gefundenerArtikel.getBezeichnung());
            System.out.println("Preis: " + gefundenerArtikel.getPreis() +  " Bestand: " + gefundenerArtikel.getBestand() );
        }
        dbVerbindung.close();
    }

    public void sucheEinenArtikelnachArtikelNr(String pArtikelNr)
    {
        datenbankOeffnen();
        vergleichsArtikel = new Artikel(pArtikelNr, null, 0, 0);
        ObjectSet abfrageErgebnis = dbVerbindung.queryByExample(vergleichsArtikel);
        while(abfrageErgebnis.hasNext()) 
        {
            gefundenerArtikel = (Artikel) abfrageErgebnis.next();
            System.out.println("Nr: " + gefundenerArtikel.getArtikelNr() +  " Bez: " + gefundenerArtikel.getBezeichnung());
            System.out.println("Preis: " + gefundenerArtikel.getPreis() +  " Bestand: " + gefundenerArtikel.getBestand() );
        }
        dbVerbindung.close();
    }

    public void aendereArtikelBezeichnung(String pArtikelNr, String pBezeichnung)
    {   
        datenbankOeffnen();
        if (pBezeichnung != "")
        {
            vergleichsArtikel = new Artikel(pArtikelNr, null, 0, 0);
            ObjectSet abfrageErgebnis = dbVerbindung.queryByExample(vergleichsArtikel);
            gefundenerArtikel = (Artikel)abfrageErgebnis.next();
            gefundenerArtikel.setBezeichnung(pBezeichnung);
        }
        System.out.println("Nr: " + gefundenerArtikel.getArtikelNr() +  " Bez: " + gefundenerArtikel.getBezeichnung());
        System.out.println("Preis: " + gefundenerArtikel.getPreis() +  " Bestand: " + gefundenerArtikel.getBestand() );
        dbVerbindung.store(gefundenerArtikel);
        dbVerbindung.close();   
    }

    public void aendereArtikelPreis(String pArtikelNr, double pPreis)
    {   
        datenbankOeffnen();
        vergleichsArtikel = new Artikel(pArtikelNr, null, 0, 0);
        ObjectSet abfrageErgebnis = dbVerbindung.queryByExample(vergleichsArtikel);
        gefundenerArtikel = (Artikel)abfrageErgebnis.next();
        gefundenerArtikel.setPreis(pPreis);
        System.out.println("Nr: " + gefundenerArtikel.getArtikelNr() +  " Bez: " + gefundenerArtikel.getBezeichnung());
        System.out.println("Preis: " + gefundenerArtikel.getPreis() +  " Bestand: " + gefundenerArtikel.getBestand() );
        dbVerbindung.store(gefundenerArtikel);
        dbVerbindung.close();   
    }

    public void mehreArtikelbestand(String pArtikelNr, int pZugang)
    {   
        datenbankOeffnen();
        vergleichsArtikel = new Artikel(pArtikelNr, null, 0, 0);
        ObjectSet abfrageErgebnis = dbVerbindung.queryByExample(vergleichsArtikel);
        gefundenerArtikel = (Artikel)abfrageErgebnis.next();
        gefundenerArtikel.mehren(pZugang);
        System.out.println("Nr: " + gefundenerArtikel.getArtikelNr() +  " Bez: " + gefundenerArtikel.getBezeichnung());
        System.out.println("Preis: " + gefundenerArtikel.getPreis() +  " Bestand: " + gefundenerArtikel.getBestand() );
        dbVerbindung.store(gefundenerArtikel);
        dbVerbindung.close();   
    }

    public void mindereArtikelbestand(String pArtikelNr, int pAbgang)
    {   
        datenbankOeffnen();
        vergleichsArtikel = new Artikel(pArtikelNr, null, 0, 0);
        ObjectSet abfrageErgebnis = dbVerbindung.queryByExample(vergleichsArtikel);
        gefundenerArtikel = (Artikel)abfrageErgebnis.next();
        gefundenerArtikel.mindern(pAbgang);
        System.out.println("Nr: " + gefundenerArtikel.getArtikelNr() +  " Bez: " + gefundenerArtikel.getBezeichnung());
        System.out.println("Preis: " + gefundenerArtikel.getPreis() +  " Bestand: " + gefundenerArtikel.getBestand() );
        dbVerbindung.store(gefundenerArtikel);
        dbVerbindung.close();   
    }

    public  void loescheArtikel(String pArtikelNr) 
    {
        datenbankOeffnen();
        vergleichsArtikel = new Artikel(pArtikelNr, null, 0, 0);
        ObjectSet abfrageErgebnis = dbVerbindung.queryByExample(vergleichsArtikel);
        gefundenerArtikel = (Artikel)abfrageErgebnis.next();
        System.out.println("Nr: " + gefundenerArtikel.getArtikelNr() +  " Bez: " + gefundenerArtikel.getBezeichnung() + " wurde gelscht");
        dbVerbindung.delete(gefundenerArtikel);
        dbVerbindung.close();  
    } 
}

