/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.typehandlers.internal;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Reflection4;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.delete.DeleteContext;
import com.db4o.internal.marshall.CollectIdContext;
import com.db4o.internal.marshall.IdObjectCollector;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.QueryingReadContext;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.ReferenceActivationContext;
import com.db4o.marshall.WriteContext;
import com.db4o.typehandlers.ActivationContext;
import com.db4o.typehandlers.CascadingTypeHandler;
import com.db4o.typehandlers.InstantiatingTypeHandler;
import com.db4o.typehandlers.QueryableTypeHandler;
import com.db4o.typehandlers.TypeHandler4;
import java.util.Collections;
import java.util.List;

public class UnmodifiableListTypeHandler
implements InstantiatingTypeHandler,
QueryableTypeHandler,
CascadingTypeHandler {
    public boolean descendsIntoMembers() {
        return true;
    }

    public void writeInstantiation(WriteContext context, Object obj) {
        Object list = Reflection4.getFieldValue(obj, "list");
        context.writeObject(list);
    }

    public Object instantiate(ReadContext context) {
        List list = (List)context.readObject();
        return Collections.unmodifiableList(list);
    }

    public void activate(ReferenceActivationContext context) {
        UnmarshallingContext unmarshallingContext = (UnmarshallingContext)context;
        Object list = Reflection4.getFieldValue(context.persistentObject(), "list");
        unmarshallingContext.container().activate(context.transaction(), list, unmarshallingContext.activationDepth());
    }

    public void write(WriteContext context, Object obj) {
    }

    public void defragment(DefragmentContext context) {
        context.copyID();
    }

    public void delete(final DeleteContext context) throws Db4oIOException {
        if (!context.cascadeDelete()) {
            return;
        }
        final Transaction transaction = context.transaction();
        final LocalObjectContainer container = (LocalObjectContainer)transaction.container();
        int listId = context.readInt();
        IdObjectCollector collector = new IdObjectCollector();
        this.collectIds(transaction, container, listId, collector);
        collector.ids().traverse(new Visitor4<TreeInt>(){

            @Override
            public void visit(TreeInt treeInt) {
                container.deleteByID(transaction, treeInt._key, context.cascadeDeleteDepth());
            }
        });
    }

    private void collectIds(Transaction transaction, LocalObjectContainer container, int listId, IdObjectCollector collector) {
        CollectIdContext subContext = CollectIdContext.forID(transaction, collector, listId);
        ByteArrayBuffer arrayElementBuffer = container.readBufferById(transaction, listId);
        ObjectHeader objectHeader = ObjectHeader.scrollBufferToContent(container, arrayElementBuffer);
        objectHeader.classMetadata().collectIDs(subContext);
    }

    public void cascadeActivation(ActivationContext context) {
        Object list = Reflection4.getFieldValue(context.targetObject(), "list");
        context.cascadeActivationToChild(list);
    }

    public TypeHandler4 readCandidateHandler(QueryingReadContext context) {
        return this;
    }

    public void collectIDs(QueryingReadContext context) {
        this.collectIds(context.transaction(), (LocalObjectContainer)context.container(), context.readInt(), context.collector());
    }
}

