/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.ta.instrumentation;

import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.EditorVisitor;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.core.InstrumentationStatus;
import com.db4o.ta.instrumentation.ClassReplacementSpec;
import java.util.HashMap;
import java.util.Map;

public class ReplaceClassOnInstantiationEdit
implements BloatClassEdit {
    final Map _replacements = new HashMap();

    public ReplaceClassOnInstantiationEdit(Class origClass, Class replacementClass) {
        this(new ClassReplacementSpec[]{new ClassReplacementSpec(origClass, replacementClass)});
    }

    public ReplaceClassOnInstantiationEdit(ClassReplacementSpec[] replacementSpecs) {
        for (int specIdx = 0; specIdx < replacementSpecs.length; ++specIdx) {
            ClassReplacementSpec spec = replacementSpecs[specIdx];
            Type origType = Type.getType(spec._origClass);
            Type replacementType = Type.getType(spec._replacementClass);
            this._replacements.put(origType, replacementType);
        }
    }

    public InstrumentationStatus enhance(ClassEditor ce, ClassLoader origLoader, BloatLoaderContext loaderContext) {
        ArrayListInstantiationMethodVisitor methodVisitor = new ArrayListInstantiationMethodVisitor();
        try {
            ce.visit(methodVisitor);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return InstrumentationStatus.FAILED;
        }
        if (methodVisitor.instrumented()) {
            ce.commit();
            return InstrumentationStatus.INSTRUMENTED;
        }
        return InstrumentationStatus.NOT_INSTRUMENTED;
    }

    private final class ArrayListInstantiationMethodVisitor
    implements EditorVisitor {
        private boolean _instrumented;

        private ArrayListInstantiationMethodVisitor() {
        }

        public void visitClassEditor(ClassEditor editor) {
            Type replacementType = (Type)ReplaceClassOnInstantiationEdit.this._replacements.get(editor.superclass());
            if (replacementType == null) {
                return;
            }
            editor.setSuperclass(replacementType);
            this._instrumented = true;
        }

        public void visitFieldEditor(FieldEditor editor) {
        }

        public void visitMethodEditor(MethodEditor editor) {
            boolean instrumented = false;
            for (Object instructionOrLabel : editor.code()) {
                if (instructionOrLabel instanceof Label) continue;
                if (!(instructionOrLabel instanceof Instruction)) {
                    throw new IllegalStateException();
                }
                Instruction instruction = (Instruction)instructionOrLabel;
                switch (instruction.origOpcode()) {
                    case 187: {
                        Type newReplacementType = (Type)ReplaceClassOnInstantiationEdit.this._replacements.get(instruction.operand());
                        if (newReplacementType == null) break;
                        instruction.setOperand(newReplacementType);
                        break;
                    }
                    case 183: {
                        MemberRef methodRef = (MemberRef)instruction.operand();
                        Type invokeReplacementType = (Type)ReplaceClassOnInstantiationEdit.this._replacements.get(methodRef.declaringClass());
                        if (invokeReplacementType == null) break;
                        instruction.setOperand(new MemberRef(invokeReplacementType, methodRef.nameAndType()));
                        instrumented = true;
                        break;
                    }
                }
            }
            if (instrumented) {
                this._instrumented = true;
                editor.commit();
            }
        }

        public boolean instrumented() {
            return this._instrumented;
        }
    }
}

