/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.optimization;

import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import com.db4o.instrumentation.bloat.BloatReferenceResolver;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.core.Db4oClassSource;
import com.db4o.internal.query.Db4oNQOptimizer;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.optimization.JdkReverseLookupClassFactory;
import com.db4o.nativequery.optimization.NativeQueryEnhancer;
import com.db4o.nativequery.optimization.SODAQueryBuilder;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import com.db4o.reflect.Reflector;
import java.util.ArrayList;

public class Db4oOnTheFlyEnhancer
implements Db4oNQOptimizer {
    private transient BloatLoaderContext bloatUtil;
    private transient EditorContext context;
    private Reflector reflector;

    public Db4oOnTheFlyEnhancer() {
        this(new ClassFileLoader());
    }

    public Db4oOnTheFlyEnhancer(Reflector reflector) {
        this(new ClassFileLoader(new Db4oClassSource(new JdkReverseLookupClassFactory(reflector))));
        this.reflector = reflector;
    }

    private Db4oOnTheFlyEnhancer(ClassFileLoader loader) {
        this.context = new CachingBloatContext(loader, new ArrayList(), false);
        this.bloatUtil = new BloatLoaderContext(this.context);
    }

    public Object optimize(Query query, Predicate filter) {
        try {
            Expression expr = this.analyzeInternal(filter);
            if (expr == null) {
                throw new RuntimeException("Could not analyze " + filter);
            }
            JdkReverseLookupClassFactory classFactory = new JdkReverseLookupClassFactory(this.reflector);
            new SODAQueryBuilder().optimizeQuery(expr, query, filter, classFactory, new BloatReferenceResolver(classFactory));
            return expr;
        }
        catch (ClassNotFoundException exc) {
            throw new RuntimeException(exc.getMessage());
        }
    }

    private Expression analyzeInternal(Predicate filter) throws ClassNotFoundException {
        ClassEditor classEditor = this.context.editClass(filter.getClass().getName());
        return new NativeQueryEnhancer().analyze(this.bloatUtil, classEditor, "match", null);
    }

    public static Expression analyze(Predicate filter) throws ClassNotFoundException {
        return new Db4oOnTheFlyEnhancer().analyzeInternal(filter);
    }
}

