/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.optimization;

import com.db4o.instrumentation.api.NativeClassFactory;
import com.db4o.instrumentation.api.ReferenceResolver;
import com.db4o.internal.Reflection4;
import com.db4o.nativequery.expr.cmp.operand.ArithmeticExpression;
import com.db4o.nativequery.expr.cmp.operand.ArrayAccessValue;
import com.db4o.nativequery.expr.cmp.operand.CandidateFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperand;
import com.db4o.nativequery.expr.cmp.operand.ComparisonOperandVisitor;
import com.db4o.nativequery.expr.cmp.operand.ConstValue;
import com.db4o.nativequery.expr.cmp.operand.FieldValue;
import com.db4o.nativequery.expr.cmp.operand.MethodCallValue;
import com.db4o.nativequery.expr.cmp.operand.PredicateFieldRoot;
import com.db4o.nativequery.expr.cmp.operand.StaticFieldRoot;
import com.db4o.nativequery.optimization.NativeQueriesPlatform;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

final class ComparisonQueryGeneratingVisitor
implements ComparisonOperandVisitor {
    private Object _predicate;
    private Object _value = null;
    private final NativeClassFactory _classSource;
    private final ReferenceResolver _resolver;

    public Object value() {
        return this._value;
    }

    public void visit(ConstValue operand) {
        this._value = operand.value();
    }

    public void visit(FieldValue operand) {
        operand.parent().accept(this);
        Class<?> clazz = operand.parent() instanceof StaticFieldRoot ? (Class<?>)this._value : this._value.getClass();
        try {
            Field field = Reflection4.getField(clazz, operand.fieldName());
            this._value = field.get(this._value);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    Object add(Object a, Object b) {
        if (a instanceof Double || b instanceof Double) {
            return new Double((Double)a + (Double)b);
        }
        if (a instanceof Float || b instanceof Float) {
            return new Float(((Float)a).floatValue() + ((Float)b).floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return new Long((Long)a + (Long)b);
        }
        return new Integer((Integer)a + (Integer)b);
    }

    Object subtract(Object a, Object b) {
        if (a instanceof Double || b instanceof Double) {
            return new Double((Double)a - (Double)b);
        }
        if (a instanceof Float || b instanceof Float) {
            return new Float(((Float)a).floatValue() - ((Float)b).floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return new Long((Long)a - (Long)b);
        }
        return new Integer((Integer)a - (Integer)b);
    }

    Object multiply(Object a, Object b) {
        if (a instanceof Double || b instanceof Double) {
            return new Double((Double)a * (Double)b);
        }
        if (a instanceof Float || b instanceof Float) {
            return new Float(((Float)a).floatValue() * ((Float)b).floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return new Long((Long)a * (Long)b);
        }
        return new Integer((Integer)a * (Integer)b);
    }

    Object divide(Object a, Object b) {
        if (a instanceof Double || b instanceof Double) {
            return new Double((Double)a / (Double)b);
        }
        if (a instanceof Float || b instanceof Float) {
            return new Float(((Float)a).floatValue() / ((Float)b).floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return new Long((Long)a / (Long)b);
        }
        return new Integer((Integer)a / (Integer)b);
    }

    Object modulo(Object a, Object b) {
        if (a instanceof Double || b instanceof Double) {
            return new Double((Double)a % (Double)b);
        }
        if (a instanceof Float || b instanceof Float) {
            return new Float(((Float)a).floatValue() % ((Float)b).floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return new Long((Long)a % (Long)b);
        }
        return new Integer((Integer)a % (Integer)b);
    }

    public void visit(ArithmeticExpression operand) {
        operand.left().accept(this);
        Object left = this._value;
        operand.right().accept(this);
        Object right = this._value;
        switch (operand.op().id()) {
            case 0: {
                this._value = this.add(left, right);
                break;
            }
            case 1: {
                this._value = this.subtract(left, right);
                break;
            }
            case 2: {
                this._value = this.multiply(left, right);
                break;
            }
            case 3: {
                this._value = this.divide(left, right);
                break;
            }
            case 4: {
                this._value = this.modulo(left, right);
            }
        }
    }

    public void visit(CandidateFieldRoot root) {
    }

    public void visit(PredicateFieldRoot root) {
        this._value = this._predicate;
    }

    public void visit(StaticFieldRoot root) {
        try {
            this._value = this._classSource.forName(root.type().name());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void visit(ArrayAccessValue operand) {
        operand.parent().accept(this);
        Object parent = this._value;
        operand.index().accept(this);
        Integer index = (Integer)this._value;
        this._value = Array.get(parent, index);
    }

    public void visit(MethodCallValue operand) {
        operand.parent().accept(this);
        Object receiver = this._value;
        Method method = this._resolver.resolve(operand.method());
        try {
            method.setAccessible(true);
            this._value = method.invoke(this.isStatic(method) ? null : receiver, this.args(operand));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this._value = null;
        }
    }

    private Object[] args(MethodCallValue operand) {
        ComparisonOperand[] args = operand.args();
        Object[] params = new Object[args.length];
        for (int paramIdx = 0; paramIdx < args.length; ++paramIdx) {
            args[paramIdx].accept(this);
            params[paramIdx] = this._value;
        }
        return params;
    }

    private boolean isStatic(Method method) {
        return NativeQueriesPlatform.isStatic(method);
    }

    public ComparisonQueryGeneratingVisitor(Object predicate, NativeClassFactory classSource, ReferenceResolver resolver) {
        this._predicate = predicate;
        this._classSource = classSource;
        this._resolver = resolver;
    }
}

