/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring.internal;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.references.ReferenceSystem;
import com.db4o.internal.references.TransactionalReferenceSystemBase;
import com.db4o.monitoring.ReferenceSystemListener;

public class MonitoringReferenceSystem
extends TransactionalReferenceSystemBase
implements ReferenceSystem {
    private final ReferenceSystemListener _referenceSystemListener;
    private int _referenceCount;

    public MonitoringReferenceSystem(ReferenceSystemListener referenceSystem) {
        this._referenceSystemListener = referenceSystem;
    }

    public void commit() {
        final IntByRef removedReferenceCount = new IntByRef();
        this.traverseNewReferences(new Visitor4(){

            public void visit(Object obj) {
                ObjectReference oref = (ObjectReference)obj;
                if (oref.getObject() != null) {
                    MonitoringReferenceSystem.this._committedReferences.addExistingReference(oref);
                } else {
                    ++removedReferenceCount.value;
                }
            }
        });
        this.createNewReferences();
        this.referenceCountChanged(-removedReferenceCount.value);
    }

    public void addExistingReference(ObjectReference ref) {
        this._committedReferences.addExistingReference(ref);
        this.referenceCountChanged(1);
    }

    public void addNewReference(ObjectReference ref) {
        this._newReferences.addNewReference(ref);
        this.referenceCountChanged(1);
    }

    public void removeReference(ObjectReference ref) {
        if (this._newReferences.referenceForId(ref.getID()) != null) {
            this._newReferences.removeReference(ref);
            this.referenceCountChanged(-1);
        }
        if (this._committedReferences.referenceForId(ref.getID()) != null) {
            this._committedReferences.removeReference(ref);
            this.referenceCountChanged(-1);
        }
    }

    public void rollback() {
        final IntByRef newReferencesCount = new IntByRef();
        this.traverseNewReferences(new Visitor4(){

            public void visit(Object obj) {
                ++newReferencesCount.value;
            }
        });
        this.createNewReferences();
        this.referenceCountChanged(-newReferencesCount.value);
    }

    private void referenceCountChanged(int changedBy) {
        if (changedBy == 0) {
            return;
        }
        this._referenceCount += changedBy;
        this._referenceSystemListener.notifyReferenceCountChanged(changedBy);
    }

    public void discarded() {
        this.referenceCountChanged(-this._referenceCount);
    }
}

