/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring.internal;

import com.db4o.foundation.Environments;
import com.db4o.monitoring.internal.Clock;

public class AveragingTimedReading {
    private final Clock _clock = Environments.my(Clock.class);
    private long _lastStart;
    private long _aggregateTime;
    private int _eventCount;

    public synchronized void eventStarted() {
        this._lastStart = this.currentTime();
    }

    public synchronized void eventFinished() {
        if (-1L == this._lastStart) {
            throw new IllegalStateException();
        }
        this._aggregateTime += this.currentTime() - this._lastStart;
        ++this._eventCount;
        this._lastStart = -1L;
    }

    public synchronized double read() {
        if (this._eventCount == 0) {
            return 0.0;
        }
        long value = this._aggregateTime / (long)this._eventCount;
        this._eventCount = 0;
        this._aggregateTime = 0L;
        this._lastStart = this.currentTime();
        return value;
    }

    private long currentTime() {
        return this._clock.currentTimeMillis();
    }
}

