/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.monitoring;

import com.db4o.ObjectContainer;
import com.db4o.diagnostic.LoadedFromClassIndex;
import com.db4o.monitoring.NotificationEmitterMBean;
import com.db4o.monitoring.QueriesMBean;
import com.db4o.monitoring.internal.AveragingTimedReading;
import com.db4o.monitoring.internal.TimedReading;
import javax.management.JMException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Queries
extends NotificationEmitterMBean
implements QueriesMBean {
    private final TimedReading _classIndexScans = TimedReading.newPerSecond();
    private final TimedReading _queries = TimedReading.newPerSecond();
    private final AveragingTimedReading _queryExecutionTime = new AveragingTimedReading();

    public Queries(ObjectContainer db, Class<?> type) throws JMException {
        super(db, type);
    }

    private static String classIndexScanNotificationType() {
        return LoadedFromClassIndex.class.getName();
    }

    @Override
    public double getClassIndexScansPerSecond() {
        return this._classIndexScans.read();
    }

    @Override
    public double getAverageQueryExecutionTime() {
        return this._queryExecutionTime.read();
    }

    @Override
    public double getQueriesPerSecond() {
        return this._queries.read();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{Queries.classIndexScanNotificationType()}, Notification.class.getName(), "Notification about class index scans.")};
    }

    public void notifyClassIndexScan(LoadedFromClassIndex d) {
        this._classIndexScans.increment();
        this.sendNotification(Queries.classIndexScanNotificationType(), d.problem(), d.reason());
    }

    public void notifyQueryStarted() {
        this._queries.increment();
        this._queryExecutionTime.eventStarted();
    }

    public void notifyQueryFinished() {
        this._queryExecutionTime.eventFinished();
    }
}

