/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.io.Bin;
import java.util.ArrayList;
import java.util.List;

class PagingMemoryBin
implements Bin {
    private final int _pageSize;
    private List<byte[]> _pages = new ArrayList<byte[]>();
    private int _lastPageLength;

    public PagingMemoryBin(int pageSize) {
        this(pageSize, 0L);
    }

    public PagingMemoryBin(int pageSize, long initialLength) {
        this._pageSize = pageSize;
        this.ensureLength(initialLength);
    }

    public long length() {
        if (this._pages.size() == 0) {
            return 0L;
        }
        return (this._pages.size() - 1) * this._pageSize + this._lastPageLength;
    }

    public int read(long pos, byte[] buffer, int length) throws Db4oIOException {
        long avail = this.length() - pos;
        if (avail <= 0L) {
            return -1;
        }
        int bytesToRead = Math.min((int)avail, length);
        int offset = this.pageOffset(pos);
        int pageIdx = this.pageIdx(pos);
        int bytesRead = 0;
        while (bytesRead < bytesToRead) {
            byte[] curPage = this._pages.get(pageIdx);
            int chunkLength = Math.min(length - bytesRead, this._pageSize - offset);
            System.arraycopy(curPage, offset, buffer, bytesRead, chunkLength);
            bytesRead += chunkLength;
            ++pageIdx;
            offset = 0;
        }
        return bytesToRead;
    }

    public void sync() throws Db4oIOException {
    }

    public int syncRead(long position, byte[] bytes, int bytesToRead) {
        return this.read(position, bytes, bytesToRead);
    }

    public void close() {
    }

    public void write(long pos, byte[] buffer, int length) throws Db4oIOException {
        this.ensureLength(pos + (long)length);
        int offset = this.pageOffset(pos);
        int pageIdx = this.pageIdx(pos);
        int bytesWritten = 0;
        while (bytesWritten < length) {
            byte[] curPage = this._pages.get(pageIdx);
            int chunkLength = Math.min(length - bytesWritten, this._pageSize - offset);
            System.arraycopy(buffer, bytesWritten, curPage, offset, chunkLength);
            bytesWritten += chunkLength;
            ++pageIdx;
            offset = 0;
        }
    }

    private void ensureLength(long length) {
        if (length <= 0L) {
            return;
        }
        long lastPos = length - 1L;
        int lastPosPageIdx = this.pageIdx(lastPos);
        int lastPosPageLength = this.pageOffset(lastPos) + 1;
        if (lastPosPageIdx == this._pages.size() - 1) {
            this._lastPageLength = Math.max(lastPosPageLength, this._lastPageLength);
            return;
        }
        if (lastPosPageIdx < this._pages.size()) {
            return;
        }
        for (int newPageIdx = this._pages.size(); newPageIdx <= lastPosPageIdx; ++newPageIdx) {
            this._pages.add(new byte[this._pageSize]);
        }
        this._lastPageLength = lastPosPageLength;
    }

    private int pageIdx(long pos) {
        return (int)(pos / (long)this._pageSize);
    }

    private int pageOffset(long pos) {
        return (int)(pos % (long)this._pageSize);
    }

    public void sync(Runnable runnable) {
        runnable.run();
    }
}

