/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.io.BlockAwareBin;

public class BlockAwareBinWindow {
    private BlockAwareBin _bin;
    private int _blockOff;
    private int _len;
    private boolean _disabled;

    public BlockAwareBinWindow(BlockAwareBin io, int blockOff, int len) {
        this._bin = io;
        this._blockOff = blockOff;
        this._len = len;
        this._disabled = false;
    }

    public int length() {
        return this._len;
    }

    public void write(int off, byte[] data) throws IllegalArgumentException, IllegalStateException {
        this.checkBounds(off, data);
        this._bin.blockWrite(this._blockOff + off, data);
    }

    public int read(int off, byte[] data) throws IllegalArgumentException, IllegalStateException {
        this.checkBounds(off, data);
        return this._bin.blockRead(this._blockOff + off, data);
    }

    public void disable() {
        this._disabled = true;
    }

    public void flush() {
        if (!this._disabled) {
            this._bin.sync();
        }
    }

    private void checkBounds(int off, byte[] data) {
        if (this._disabled) {
            throw new IllegalStateException();
        }
        if (data == null || off < 0 || off + data.length > this._len) {
            throw new IllegalArgumentException();
        }
    }
}

