/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.transactionlog;

import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.Visitable;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LockedTree;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionLogHandler {
    protected final LocalObjectContainer _container;

    protected TransactionLogHandler(LocalObjectContainer container) {
        this._container = container;
    }

    protected LocalObjectContainer localContainer() {
        return this._container;
    }

    protected final void flushDatabaseFile() {
        this._container.syncFiles();
    }

    protected final void appendSlotChanges(final ByteArrayBuffer writer, Visitable slotChangeVisitable) {
        slotChangeVisitable.accept(new Visitor4(){

            public void visit(Object obj) {
                ((SlotChange)obj).write(writer);
            }
        });
    }

    protected boolean writeSlots(Visitable<SlotChange> slotChangeTree) {
        final BooleanByRef ret = new BooleanByRef();
        slotChangeTree.accept(new Visitor4(){

            public void visit(Object obj) {
                ((SlotChange)obj).writePointer(TransactionLogHandler.this._container);
                ret.value = true;
            }
        });
        return ret.value;
    }

    protected final int transactionLogSlotLength(int slotChangeCount) {
        return (slotChangeCount * 3 + 2) * 4;
    }

    public abstract Slot allocateSlot(boolean var1, int var2);

    public abstract void applySlotChanges(Visitable<SlotChange> var1, int var2, Slot var3);

    public abstract void completeInterruptedTransaction(int var1, int var2);

    public abstract void close();

    protected void readWriteSlotChanges(ByteArrayBuffer buffer) {
        final LockedTree slotChanges = new LockedTree();
        slotChanges.read(buffer, new SlotChange(0));
        if (this.writeSlots(new Visitable<SlotChange>(){

            @Override
            public void accept(Visitor4<SlotChange> visitor) {
                slotChanges.traverseMutable(visitor);
            }
        })) {
            this.flushDatabaseFile();
        }
    }
}

