/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Closure4;
import com.db4o.internal.AbstractBufferContext;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.Handlers4;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.UnknownActivationDepth;
import com.db4o.internal.marshall.InternalReadContext;
import com.db4o.marshall.ReadBuffer;
import com.db4o.typehandlers.TypeHandler4;

public abstract class AbstractReadContext
extends AbstractBufferContext
implements InternalReadContext {
    protected ActivationDepth _activationDepth = UnknownActivationDepth.INSTANCE;
    private boolean _lastReferenceReadWasReallyNull = false;

    protected AbstractReadContext(Transaction transaction, ReadBuffer buffer) {
        super(transaction, buffer);
    }

    protected AbstractReadContext(Transaction transaction) {
        this(transaction, null);
    }

    public final Object read(TypeHandler4 handlerType) {
        return this.readObject(handlerType);
    }

    public final Object readObject(TypeHandler4 handlerType) {
        if (null == handlerType) {
            throw new ArgumentNullException();
        }
        final TypeHandler4 handler = HandlerRegistry.correctHandlerVersion(this, handlerType);
        return this.slotFormat().doWithSlotIndirection(this, handler, new Closure4(){

            public Object run() {
                return AbstractReadContext.this.readAtCurrentSeekPosition(handler);
            }
        });
    }

    public Object readAtCurrentSeekPosition(TypeHandler4 handler) {
        if (Handlers4.useDedicatedSlot(this, handler)) {
            return this.readObject();
        }
        return Handlers4.readValueType(this, handler);
    }

    public final Object readObject() {
        int objectId = this.readInt();
        if (objectId == 0) {
            this._lastReferenceReadWasReallyNull = true;
            return null;
        }
        this._lastReferenceReadWasReallyNull = false;
        if (objectId == 1) {
            return null;
        }
        ClassMetadata classMetadata = this.classMetadataForObjectId(objectId);
        if (null == classMetadata) {
            return null;
        }
        ActivationDepth depth = this.activationDepth().descend(classMetadata);
        if (this.peekPersisted()) {
            return this.container().peekPersisted(this.transaction(), objectId, depth, false);
        }
        Object obj = this.container().getByID2(this.transaction(), objectId);
        if (null == obj) {
            return null;
        }
        this.container().stillToActivate(this.container().activationContextFor(this.transaction(), obj, depth));
        return obj;
    }

    private ClassMetadata classMetadataForObjectId(int objectId) {
        HardObjectReference hardRef = this.container().getHardObjectReferenceById(this.transaction(), objectId);
        if (null == hardRef || hardRef._reference == null) {
            return null;
        }
        return hardRef._reference.classMetadata();
    }

    protected boolean peekPersisted() {
        return false;
    }

    public ActivationDepth activationDepth() {
        return this._activationDepth;
    }

    public void activationDepth(ActivationDepth depth) {
        this._activationDepth = depth;
    }

    public ReadWriteBuffer readIndirectedBuffer() {
        int address = this.readInt();
        int length = this.readInt();
        if (address == 0) {
            return null;
        }
        return this.container().decryptedBufferByAddress(address, length);
    }

    public boolean lastReferenceReadWasReallyNull() {
        return this._lastReferenceReadWasReallyNull;
    }

    public void notifyNullReferenceSkipped() {
        this._lastReferenceReadWasReallyNull = true;
    }
}

