/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Pair;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.Visitable;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.IoAdaptedObjectContainer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ids.FreespaceCommitter;
import com.db4o.internal.ids.IdSystem;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;
import com.db4o.internal.transactionlog.EmbeddedTransactionLogHandler;
import com.db4o.internal.transactionlog.FileBasedTransactionLogHandler;
import com.db4o.internal.transactionlog.TransactionLogHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PointerBasedIdSystem
implements IdSystem {
    final TransactionLogHandler _transactionLogHandler;
    private final LocalObjectContainer _container;

    public PointerBasedIdSystem(LocalObjectContainer container) {
        this._container = container;
        this._transactionLogHandler = this.newTransactionLogHandler(container);
    }

    @Override
    public int newId() {
        return this._container.allocatePointerSlot();
    }

    @Override
    public final Slot committedSlot(int id) {
        return this._container.readPointerSlot(id);
    }

    @Override
    public void commit(Visitable<SlotChange> slotChanges, FreespaceCommitter freespaceCommitter) {
        Slot reservedSlot = this._transactionLogHandler.allocateSlot(false, this.countSlotChanges(slotChanges));
        freespaceCommitter.commit();
        this._transactionLogHandler.applySlotChanges(slotChanges, this.countSlotChanges(slotChanges), reservedSlot);
    }

    private int countSlotChanges(Visitable<SlotChange> slotChanges) {
        final IntByRef slotChangeCount = new IntByRef();
        slotChanges.accept(new Visitor4<SlotChange>(){

            @Override
            public void visit(SlotChange slotChange) {
                if (slotChange.slotModified()) {
                    ++slotChangeCount.value;
                }
            }
        });
        return slotChangeCount.value;
    }

    @Override
    public void returnUnusedIds(Visitable<Integer> visitable) {
        visitable.accept(new Visitor4<Integer>(){

            @Override
            public void visit(Integer id) {
                PointerBasedIdSystem.this._container.free(id, 8);
            }
        });
    }

    private TransactionLogHandler newTransactionLogHandler(LocalObjectContainer container) {
        boolean fileBased;
        boolean bl = fileBased = container.config().fileBasedTransactionLog() && container instanceof IoAdaptedObjectContainer;
        if (!fileBased) {
            return new EmbeddedTransactionLogHandler(container);
        }
        String fileName = ((IoAdaptedObjectContainer)container).fileName();
        return new FileBasedTransactionLogHandler(container, fileName);
    }

    @Override
    public void close() {
        this._transactionLogHandler.close();
    }

    @Override
    public void completeInterruptedTransaction(int transactionId1, int transactionId2) {
        this._transactionLogHandler.completeInterruptedTransaction(transactionId1, transactionId2);
    }

    @Override
    public void traverseOwnSlots(Procedure4<Pair<Integer, Slot>> block) {
    }
}

