/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.freespace.NullFreespaceManager;
import com.db4o.internal.ids.TransactionalIdSystem;
import com.db4o.internal.slots.Slot;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreespaceCommitter {
    public static final FreespaceCommitter DO_NOTHING = new NullFreespaceCommitter();
    private final List<Slot> _freeToUserFreespaceSystem = new ArrayList<Slot>();
    private final List<Slot> _freeToSystemFreespaceSystem = new ArrayList<Slot>();
    private final FreespaceManager _freespaceManager;
    private TransactionalIdSystem _transactionalIdSystem;

    public FreespaceCommitter(FreespaceManager freespaceManager) {
        this._freespaceManager = freespaceManager == null ? NullFreespaceManager.INSTANCE : freespaceManager;
    }

    public void commit() {
        this.apply(this._freeToUserFreespaceSystem);
        this._freespaceManager.beginCommit();
        this._freespaceManager.commit();
        this._transactionalIdSystem.accumulateFreeSlots(this, true);
        this.apply(this._freeToSystemFreespaceSystem);
        this._freespaceManager.endCommit();
    }

    private void apply(List<Slot> toFree) {
        for (Slot slot : toFree) {
            this._freespaceManager.free(slot);
        }
        toFree.clear();
    }

    public void transactionalIdSystem(TransactionalIdSystem transactionalIdSystem) {
        this._transactionalIdSystem = transactionalIdSystem;
    }

    public void delayedFree(Slot slot, boolean freeToSystemFreeSpaceSystem) {
        if (freeToSystemFreeSpaceSystem) {
            this._freeToSystemFreespaceSystem.add(slot);
        } else {
            this._freeToUserFreespaceSystem.add(slot);
        }
    }

    private static class NullFreespaceCommitter
    extends FreespaceCommitter {
        public NullFreespaceCommitter() {
            super(NullFreespaceManager.INSTANCE);
        }

        public void commit() {
        }
    }
}

