/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers.array;

import com.db4o.foundation.Iterator4;
import com.db4o.internal.handlers.array.ReflectArrayIterator;
import com.db4o.reflect.ReflectArray;

public class MultidimensionalArrayIterator
implements Iterator4 {
    private final ReflectArray _reflectArray;
    private final Object[] _array;
    private int _currentElement;
    private Iterator4 _delegate;

    public MultidimensionalArrayIterator(ReflectArray reflectArray, Object[] array) {
        this._reflectArray = reflectArray;
        this._array = array;
        this.reset();
    }

    public Object current() {
        if (this._delegate == null) {
            return this._array[this._currentElement];
        }
        return this._delegate.current();
    }

    public boolean moveNext() {
        if (this._delegate != null) {
            if (this._delegate.moveNext()) {
                return true;
            }
            this._delegate = null;
        }
        ++this._currentElement;
        if (this._currentElement >= this._array.length) {
            return false;
        }
        Object obj = this._array[this._currentElement];
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            this._delegate = clazz.getComponentType().isArray() ? new MultidimensionalArrayIterator(this._reflectArray, (Object[])obj) : new ReflectArrayIterator(this._reflectArray, obj);
            return this.moveNext();
        }
        return true;
    }

    public void reset() {
        this._currentElement = -1;
        this._delegate = null;
    }
}

