/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.DTrace;
import com.db4o.defragment.DefragmentServices;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.ByRef;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.PreparedComparison;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.Indexable4;
import com.db4o.internal.LocalPersistentBase;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionLocal;
import com.db4o.internal.TransactionParticipant;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.btree.BTreeConfiguration;
import com.db4o.internal.btree.BTreeIterator;
import com.db4o.internal.btree.BTreeNode;
import com.db4o.internal.btree.BTreeNodeCacheEntry;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.BTreeRangeSingle;
import com.db4o.internal.btree.BTreeStructureListener;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.caching.Cache4;
import com.db4o.internal.caching.CacheFactory;
import com.db4o.internal.ids.TransactionalIdSystem;
import com.db4o.internal.slots.SlotChangeFactory;
import com.db4o.marshall.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTree
extends LocalPersistentBase
implements TransactionParticipant,
BTreeStructureListener {
    private final BTreeConfiguration _config;
    private static final byte BTREE_VERSION = 1;
    private static final int DEFRAGMENT_INCREMENT_OFFSET = 9;
    private final Indexable4 _keyHandler;
    private BTreeNode _root;
    private TreeIntObject _nodes;
    private int _size;
    private Visitor4 _removeListener;
    private final TransactionLocal<Integer> _sizeDeltaInTransaction = new TransactionLocal<Integer>(){

        @Override
        public Integer initialValueFor(Transaction transaction) {
            return 0;
        }
    };
    protected Queue4 _processing;
    private int _nodeSize;
    int _halfNodeSize;
    private BTreeStructureListener _structureListener;
    private final Cache4<Integer, BTreeNodeCacheEntry> _nodeCache;
    private TreeIntObject _evictedFromCache;
    private boolean _disposed;

    public BTree(Transaction trans, BTreeConfiguration config, int id, Indexable4 keyHandler, int treeNodeSize) {
        super(config._idSystem);
        this._config = config;
        if (null == keyHandler) {
            throw new ArgumentNullException();
        }
        this._nodeSize = treeNodeSize;
        this._nodeCache = CacheFactory.newLRUIntCache(config._cacheSize);
        this._halfNodeSize = this._nodeSize / 2;
        this._nodeSize = this._halfNodeSize * 2;
        this._keyHandler = keyHandler;
        this.setID(id);
        if (this.isNew()) {
            this.setStateDirty();
            this._root = new BTreeNode(this, 0, true, 0, 0, 0);
            this._root.write(trans.systemTransaction());
            this.addNode(this._root);
            this.write(trans.systemTransaction());
        } else {
            this.setStateDeactivated();
        }
    }

    public BTree(Transaction trans, BTreeConfiguration config, Indexable4 keyHandler) {
        this(trans, config, 0, keyHandler);
    }

    public BTree(Transaction trans, BTreeConfiguration config, int id, Indexable4 keyHandler) {
        this(trans, config, id, keyHandler, BTree.config(trans).bTreeNodeSize());
    }

    public BTree(Transaction trans, int id, Indexable4 keyHandler) {
        this(trans, BTreeConfiguration.DEFAULT, id, keyHandler);
    }

    public BTree(Transaction trans, int id, Indexable4 keyHandler, int nodeSize) {
        this(trans, BTreeConfiguration.DEFAULT, id, keyHandler, nodeSize);
    }

    public BTreeNode root() {
        return this._root;
    }

    public int nodeSize() {
        return this._nodeSize;
    }

    public void add(Transaction trans, Object key) {
        this.keyCantBeNull(key);
        PreparedComparison preparedComparison = this._keyHandler.prepareComparison(trans.context(), key);
        this.add(trans, preparedComparison, key);
    }

    public void add(Transaction trans, PreparedComparison preparedComparison, Object key) {
        this.ensureActive(trans);
        this.enlist(trans);
        BTreeNode rootOrSplit = this._root.add(trans, preparedComparison, key);
        if (rootOrSplit != null && rootOrSplit != this._root) {
            this.ensureDirty(trans);
            this._root = new BTreeNode(trans, this._root, rootOrSplit);
            this._root.write(trans.systemTransaction());
            this.addNode(this._root);
        }
        this.convertCacheEvictedNodesToReadMode();
    }

    public Object remove(Transaction trans, Object key) {
        BTreePointer bTreePointer = this.searchPointer(trans, key);
        if (bTreePointer == null) {
            return null;
        }
        Object result = bTreePointer.key();
        this.enlist(trans);
        PreparedComparison preparedComparison = this.keyHandler().prepareComparison(trans.context(), key);
        BTreeNode node = bTreePointer.node();
        node.remove(trans, preparedComparison, key, bTreePointer.index());
        this.convertCacheEvictedNodesToReadMode();
        return result;
    }

    public BTreeRange searchRange(Transaction trans, Object key) {
        this.keyCantBeNull(key);
        return this.searchRange(trans, this.keyHandler().prepareComparison(trans.context(), key));
    }

    public BTreePointer searchPointer(Transaction trans, Object key) {
        this.ensureActive(trans);
        this.keyCantBeNull(key);
        PreparedComparison preparedComparison = this.keyHandler().prepareComparison(trans.context(), key);
        BTreeNodeSearchResult start = this.searchLeaf(trans, preparedComparison, SearchTarget.LOWEST);
        BTreePointer bTreePointer = start.firstValidPointer();
        if (bTreePointer == null) {
            this.convertCacheEvictedNodesToReadMode();
            return null;
        }
        Object found = bTreePointer.key();
        this.convertCacheEvictedNodesToReadMode();
        if (preparedComparison.compareTo(found) == 0) {
            return bTreePointer;
        }
        return null;
    }

    public Object search(Transaction trans, Object key) {
        BTreePointer bTreePointer = this.searchPointer(trans, key);
        if (bTreePointer != null) {
            return bTreePointer.key();
        }
        return null;
    }

    private BTreeRange searchRange(Transaction trans, PreparedComparison preparedComparison) {
        this.ensureActive(trans);
        BTreeNodeSearchResult start = this.searchLeaf(trans, preparedComparison, SearchTarget.LOWEST);
        BTreeNodeSearchResult end = this.searchLeaf(trans, preparedComparison, SearchTarget.HIGHEST);
        BTreeRange range = start.createIncludingRange(end);
        this.convertCacheEvictedNodesToReadMode();
        return range;
    }

    private void keyCantBeNull(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
    }

    public Indexable4 keyHandler() {
        return this._keyHandler;
    }

    public BTreeNodeSearchResult searchLeaf(Transaction trans, Object key, SearchTarget target) {
        return this.searchLeaf(trans, this._keyHandler.prepareComparison(trans.context(), key), target);
    }

    public BTreeNodeSearchResult searchLeaf(Transaction trans, PreparedComparison preparedComparison, SearchTarget target) {
        this.ensureActive(trans);
        BTreeNodeSearchResult result = this._root.searchLeaf(trans, preparedComparison, target);
        this.convertCacheEvictedNodesToReadMode();
        return result;
    }

    @Override
    public void commit(Transaction transaction) {
        if (this._disposed) {
            return;
        }
        this.updateSize(transaction);
        this.commitNodes(transaction);
        this.finishTransaction(transaction);
        this.convertCacheEvictedNodesToReadMode();
    }

    private void updateSize(Transaction transaction) {
        ByRef<Integer> sizeInTransaction = this.sizeIn(transaction);
        int sizeModification = (Integer)sizeInTransaction.value;
        if (sizeModification == 0) {
            return;
        }
        this.ensureDirty(transaction);
        this._size += sizeModification;
        sizeInTransaction.value = 0;
    }

    private ByRef<Integer> sizeIn(Transaction trans) {
        return trans.get(this._sizeDeltaInTransaction);
    }

    private void commitNodes(final Transaction trans) {
        this.processEachNode(new Procedure4<BTreeNode>(){

            @Override
            public void apply(BTreeNode node) {
                node.commit(trans);
            }
        });
    }

    private void processEachNode(Procedure4<BTreeNode> action) {
        if (this._nodes == null) {
            return;
        }
        this.processAllNodes();
        while (this._processing.hasNext()) {
            action.apply((BTreeNode)this._processing.next());
        }
        this._processing = null;
    }

    @Override
    public void rollback(Transaction trans) {
        this.rollbackNodes(trans);
        this.finishTransaction(trans);
        this.convertCacheEvictedNodesToReadMode();
    }

    private void finishTransaction(Transaction trans) {
        Transaction systemTransaction = trans.systemTransaction();
        this.writeAllNodes(systemTransaction);
        this.write(systemTransaction);
        this.purge();
    }

    private void rollbackNodes(final Transaction trans) {
        this.processEachNode(new Procedure4<BTreeNode>(){

            @Override
            public void apply(BTreeNode node) {
                node.rollback(trans);
            }
        });
    }

    private void writeAllNodes(final Transaction systemTransaction) {
        if (this._nodes == null) {
            return;
        }
        this._nodes.traverse(new Visitor4<TreeIntObject>(){

            @Override
            public void visit(TreeIntObject obj) {
                ((BTreeNode)obj.getObject()).write(systemTransaction);
            }
        });
    }

    private void purge() {
        if (this._nodes == null) {
            return;
        }
        TreeIntObject temp = this._nodes;
        this._nodes = null;
        this._root.holdChildrenAsIDs();
        this.addNode(this._root);
        temp.traverse(new Visitor4(){

            public void visit(Object obj) {
                BTreeNode node = (BTreeNode)((TreeIntObject)obj).getObject();
                node.purge();
            }
        });
        for (BTreeNodeCacheEntry entry : this._nodeCache) {
            entry._node.holdChildrenAsIDs();
        }
    }

    private void processAllNodes() {
        this._processing = new NonblockingQueue();
        this._nodes.traverse(new Visitor4<TreeIntObject>(){

            @Override
            public void visit(TreeIntObject node) {
                BTree.this._processing.add(node.getObject());
            }
        });
    }

    private void ensureActive(Transaction trans) {
        if (!this.isActive()) {
            this.read(trans.systemTransaction());
        }
    }

    private void ensureDirty(Transaction trans) {
        this.ensureActive(trans);
        this.enlist(trans);
        this.setStateDirty();
    }

    private void enlist(Transaction trans) {
        if (this.canEnlistWithTransaction()) {
            ((LocalTransaction)trans).enlist(this);
        }
    }

    protected boolean canEnlistWithTransaction() {
        return this._config._canEnlistWithTransaction;
    }

    @Override
    public byte getIdentifier() {
        return 84;
    }

    public void setRemoveListener(Visitor4 vis) {
        this._removeListener = vis;
    }

    @Override
    public int ownLength() {
        return 13;
    }

    public BTreeNode produceNode(int id) {
        if (DTrace.enabled) {
            DTrace.BTREE_PRODUCE_NODE.log(id);
        }
        TreeIntObject addtio = new TreeIntObject(id);
        this._nodes = Tree.add(this._nodes, addtio);
        TreeIntObject tio = (TreeIntObject)addtio.addedOrExisting();
        BTreeNode node = (BTreeNode)tio.getObject();
        if (node == null) {
            node = this.cacheEntry((BTreeNode)new BTreeNode((int)id, (BTree)this))._node;
            tio.setObject(node);
            this.addToProcessing(node);
        }
        return node;
    }

    void addNode(BTreeNode node) {
        this._nodes = Tree.add(this._nodes, new TreeIntObject<BTreeNode>(node.getID(), node));
        this.addToProcessing(node);
    }

    void addToProcessing(BTreeNode node) {
        if (this._processing != null) {
            this._processing.add(node);
        }
    }

    void removeNode(BTreeNode node) {
        this._nodes = (TreeIntObject)this._nodes.removeLike(new TreeInt(node.getID()));
    }

    void notifyRemoveListener(Object obj) {
        if (this._removeListener != null) {
            this._removeListener.visit(obj);
        }
    }

    @Override
    public void readThis(Transaction a_trans, ByteArrayBuffer a_reader) {
        a_reader.incrementOffset(1);
        this._size = a_reader.readInt();
        this._nodeSize = a_reader.readInt();
        this._halfNodeSize = this.nodeSize() / 2;
        this._root = this.produceNode(a_reader.readInt());
    }

    @Override
    public void writeThis(Transaction trans, ByteArrayBuffer a_writer) {
        a_writer.writeByte((byte)1);
        a_writer.writeInt(this._size);
        a_writer.writeInt(this.nodeSize());
        a_writer.writeIDOf(trans, this._root);
    }

    public int size(Transaction trans) {
        this.ensureActive(trans);
        return this._size + (Integer)this.sizeIn((Transaction)trans).value;
    }

    public void traverseKeys(Transaction trans, Visitor4 visitor) {
        this.ensureActive(trans);
        if (this._root == null) {
            return;
        }
        this._root.traverseKeys(trans, visitor);
        this.convertCacheEvictedNodesToReadMode();
    }

    public void sizeChanged(Transaction transaction, BTreeNode node, int changeBy) {
        this.notifyCountChanged(transaction, node, changeBy);
        ByRef<Integer> sizeInTransaction = this.sizeIn(transaction);
        sizeInTransaction.value = (Integer)sizeInTransaction.value + changeBy;
    }

    @Override
    public void dispose(Transaction transaction) {
    }

    public BTreePointer firstPointer(Transaction trans) {
        this.ensureActive(trans);
        if (null == this._root) {
            return null;
        }
        BTreePointer pointer = this._root.firstPointer(trans);
        this.convertCacheEvictedNodesToReadMode();
        return pointer;
    }

    public BTreePointer lastPointer(Transaction trans) {
        this.ensureActive(trans);
        if (null == this._root) {
            return null;
        }
        BTreePointer pointer = this._root.lastPointer(trans);
        this.convertCacheEvictedNodesToReadMode();
        return pointer;
    }

    public BTree debugLoadFully(Transaction trans) {
        this.ensureActive(trans);
        this._root.debugLoadFully(trans);
        return this;
    }

    private void traverseAllNodes(Transaction trans, Visitor4 command) {
        this.ensureActive(trans);
        this._root.traverseAllNodes(trans, command);
    }

    public void defragIndex(DefragmentContextImpl context) {
        context.incrementOffset(9);
        context.copyID();
    }

    public void defragIndexNode(DefragmentContextImpl context) {
        BTreeNode.defragIndex(context, this._keyHandler);
    }

    public void defragBTree(final DefragmentServices services) {
        DefragmentContextImpl.processCopy(services, this.getID(), new SlotCopyHandler(){

            public void processCopy(DefragmentContextImpl context) {
                BTree.this.defragIndex(context);
            }
        });
        services.traverseAllIndexSlots(this, new Visitor4(){

            public void visit(Object obj) {
                int id = (Integer)obj;
                DefragmentContextImpl.processCopy(services, id, new SlotCopyHandler(){

                    public void processCopy(DefragmentContextImpl context) {
                        BTree.this.defragIndexNode(context);
                    }
                });
            }
        });
        this.convertCacheEvictedNodesToReadMode();
    }

    int compareKeys(Context context, Object key1, Object key2) {
        PreparedComparison preparedComparison = this._keyHandler.prepareComparison(context, key1);
        return preparedComparison.compareTo(key2);
    }

    private static Config4Impl config(Transaction trans) {
        if (null == trans) {
            throw new ArgumentNullException();
        }
        return trans.container().configImpl();
    }

    @Override
    public void free(LocalTransaction systemTrans) {
        this._disposed = true;
        this.freeAllNodeIds(systemTrans, this.allNodeIds(systemTrans));
        super.free(systemTrans);
    }

    private void freeAllNodeIds(LocalTransaction systemTrans, Iterator4 allNodeIDs) {
        TransactionalIdSystem idSystem = this.idSystem(systemTrans);
        while (allNodeIDs.moveNext()) {
            int id = (Integer)allNodeIDs.current();
            idSystem.notifySlotDeleted(id, this.slotChangeFactory());
        }
    }

    public Iterator4 allNodeIds(Transaction systemTrans) {
        final Collection4 allNodeIDs = new Collection4();
        this.traverseAllNodes(systemTrans, new Visitor4(){

            public void visit(Object node) {
                allNodeIDs.add(new Integer(((BTreeNode)node).getID()));
            }
        });
        return allNodeIDs.iterator();
    }

    public BTreeRange asRange(Transaction trans) {
        return new BTreeRangeSingle(trans, this, this.firstPointer(trans), null);
    }

    private void traverseAllNodes(final Visitor4 visitor) {
        if (this._nodes == null) {
            return;
        }
        this._nodes.traverse(new Visitor4(){

            public void visit(Object obj) {
                visitor.visit(((TreeIntObject)obj).getObject());
            }
        });
    }

    public String toString() {
        final StringBuffer sb = new StringBuffer();
        sb.append("BTree ");
        sb.append(this.getID());
        sb.append(" Active Nodes: \n");
        this.traverseAllNodes(new Visitor4(){

            public void visit(Object obj) {
                sb.append(obj);
                sb.append("\n");
            }
        });
        return sb.toString();
    }

    public void structureListener(BTreeStructureListener listener) {
        this._structureListener = listener;
    }

    @Override
    public void notifySplit(Transaction trans, BTreeNode originalNode, BTreeNode newRightNode) {
        if (this._structureListener != null) {
            this._structureListener.notifySplit(trans, originalNode, newRightNode);
        }
    }

    @Override
    public void notifyDeleted(Transaction trans, BTreeNode node) {
        if (this._structureListener != null) {
            this._structureListener.notifyDeleted(trans, node);
        }
    }

    @Override
    public void notifyCountChanged(Transaction trans, BTreeNode node, int diff) {
        if (this._structureListener != null) {
            this._structureListener.notifyCountChanged(trans, node, diff);
        }
    }

    public Iterator4 iterator(Transaction trans) {
        return new BTreeIterator(trans, this);
    }

    public void clear(Transaction transaction) {
        for (BTreePointer currentPointer = this.firstPointer(transaction); currentPointer != null && currentPointer.isValid(); currentPointer = currentPointer.next()) {
            BTreeNode node = currentPointer.node();
            int index = currentPointer.index();
            node.remove(transaction, index);
        }
    }

    public Cache4<Integer, BTreeNodeCacheEntry> nodeCache() {
        return this._nodeCache;
    }

    BTreeNodeCacheEntry cacheEntry(final BTreeNode node) {
        return this._nodeCache.produce(node.getID(), new Function4<Integer, BTreeNodeCacheEntry>(){

            @Override
            public BTreeNodeCacheEntry apply(Integer id) {
                return new BTreeNodeCacheEntry(node);
            }
        }, new Procedure4<BTreeNodeCacheEntry>(){

            @Override
            public void apply(BTreeNodeCacheEntry entry) {
                BTree.this.evictedFromCache(entry._node);
            }
        });
    }

    @Override
    public SlotChangeFactory slotChangeFactory() {
        return this._config._slotChangeFactory;
    }

    public void evictedFromCache(BTreeNode node) {
        this._evictedFromCache = Tree.add(this._evictedFromCache, new TreeIntObject<BTreeNode>(node.getID(), node));
    }

    public void convertCacheEvictedNodesToReadMode() {
        if (this._evictedFromCache == null) {
            return;
        }
        Tree.traverse(this._evictedFromCache, new Visitor4<TreeIntObject>(){

            @Override
            public void visit(TreeIntObject treeIntObject) {
                ((BTreeNode)treeIntObject._object).toReadMode();
            }
        });
        this._evictedFromCache = null;
    }
}

