/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ReadWriteable;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCandidates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeInt
extends Tree<Integer>
implements ReadWriteable {
    public int _key;

    public static TreeInt add(TreeInt tree, int value) {
        return Tree.add(tree, new TreeInt(value));
    }

    public static TreeInt removeLike(TreeInt tree, int value) {
        return (TreeInt)Tree.removeLike(tree, new TreeInt(value));
    }

    public static Tree addAll(Tree tree, IntIterator4 iter) {
        if (!iter.moveNext()) {
            return tree;
        }
        TreeInt firstAdded = new TreeInt(iter.currentInt());
        tree = Tree.add(tree, firstAdded);
        while (iter.moveNext()) {
            tree = tree.add(new TreeInt(iter.currentInt()));
        }
        return tree;
    }

    public TreeInt(int a_key) {
        this._key = a_key;
    }

    @Override
    public int compare(Tree a_to) {
        return this._key - ((TreeInt)a_to)._key;
    }

    Tree deepClone() {
        return new TreeInt(this._key);
    }

    @Override
    public boolean duplicates() {
        return false;
    }

    public static final TreeInt find(Tree a_in, int a_key) {
        if (a_in == null) {
            return null;
        }
        return ((TreeInt)a_in).find(a_key);
    }

    public final TreeInt find(int a_key) {
        int cmp = this._key - a_key;
        if (cmp < 0) {
            if (this._subsequent != null) {
                return ((TreeInt)this._subsequent).find(a_key);
            }
        } else if (cmp > 0) {
            if (this._preceding != null) {
                return ((TreeInt)this._preceding).find(a_key);
            }
        } else {
            return this;
        }
        return null;
    }

    @Override
    public Object read(ByteArrayBuffer buffer) {
        return new TreeInt(buffer.readInt());
    }

    @Override
    public void write(ByteArrayBuffer buffer) {
        buffer.writeInt(this._key);
    }

    public static void write(ByteArrayBuffer buffer, TreeInt tree) {
        TreeInt.write(buffer, tree, tree == null ? 0 : tree.size());
    }

    public static void write(final ByteArrayBuffer buffer, TreeInt tree, int size) {
        if (tree == null) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(size);
        tree.traverse(new Visitor4(){

            public void visit(Object a_object) {
                ((TreeInt)a_object).write(buffer);
            }
        });
    }

    public int ownLength() {
        return 4;
    }

    boolean variableLength() {
        return false;
    }

    QCandidate toQCandidate(QCandidates candidates) {
        QCandidate qc = new QCandidate(candidates, null, this._key);
        qc._preceding = TreeInt.toQCandidate((TreeInt)this._preceding, candidates);
        qc._subsequent = TreeInt.toQCandidate((TreeInt)this._subsequent, candidates);
        qc._size = this._size;
        return qc;
    }

    public static QCandidate toQCandidate(TreeInt tree, QCandidates candidates) {
        if (tree == null) {
            return null;
        }
        return tree.toQCandidate(candidates);
    }

    public String toString() {
        return "" + this._key;
    }

    @Override
    protected Tree shallowCloneInternal(Tree tree) {
        TreeInt treeint = (TreeInt)super.shallowCloneInternal(tree);
        treeint._key = this._key;
        return treeint;
    }

    @Override
    public Object shallowClone() {
        TreeInt treeint = new TreeInt(this._key);
        return this.shallowCloneInternal(treeint);
    }

    public static int marshalledLength(TreeInt a_tree) {
        if (a_tree == null) {
            return 4;
        }
        return a_tree.marshalledLength();
    }

    @Override
    public final int marshalledLength() {
        if (this.variableLength()) {
            final IntByRef length = new IntByRef(4);
            this.traverse(new Visitor4(){

                public void visit(Object obj) {
                    length.value += ((TreeInt)obj).ownLength();
                }
            });
            return length.value;
        }
        return this.marshalledLength(this.size());
    }

    public final int marshalledLength(int size) {
        return 4 + size * this.ownLength();
    }

    @Override
    public Integer key() {
        return new Integer(this._key);
    }

    public boolean equals(Object obj) {
        TreeInt other = (TreeInt)obj;
        return other._key == this._key;
    }
}

