/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Queue4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Transaction;

class PendingClassInits {
    private final Transaction _systemTransaction;
    private Collection4 _pending = new Collection4();
    private Queue4<ClassMetadata> _members = new NonblockingQueue<ClassMetadata>();
    private Queue4<ClassMetadata> _statics = new NonblockingQueue<ClassMetadata>();
    private Queue4<ClassMetadata> _writes = new NonblockingQueue<ClassMetadata>();
    private Queue4<ClassMetadata> _inits = new NonblockingQueue<ClassMetadata>();
    private boolean _running = false;

    PendingClassInits(Transaction systemTransaction) {
        this._systemTransaction = systemTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(ClassMetadata newClassMetadata) {
        if (this._pending.contains(newClassMetadata)) {
            return;
        }
        ClassMetadata ancestor = newClassMetadata.getAncestor();
        if (ancestor != null) {
            this.process(ancestor);
        }
        this._pending.add(newClassMetadata);
        this._members.add(newClassMetadata);
        if (this._running) {
            return;
        }
        this._running = true;
        try {
            this.checkInits();
            this._pending = new Collection4();
        }
        finally {
            this._running = false;
        }
    }

    private void initializeAspects() {
        while (this._members.hasNext()) {
            ClassMetadata classMetadata = this._members.next();
            classMetadata.initializeAspects();
            this._statics.add(classMetadata);
        }
    }

    private void checkStatics() {
        this.initializeAspects();
        while (this._statics.hasNext()) {
            ClassMetadata classMetadata = this._statics.next();
            classMetadata.storeStaticFieldValues(this._systemTransaction, true);
            this._writes.add(classMetadata);
            this.initializeAspects();
        }
    }

    private void checkWrites() {
        this.checkStatics();
        while (this._writes.hasNext()) {
            ClassMetadata classMetadata = this._writes.next();
            classMetadata.setStateDirty();
            classMetadata.write(this._systemTransaction);
            this._inits.add(classMetadata);
            this.checkStatics();
        }
    }

    private void checkInits() {
        this.checkWrites();
        while (this._inits.hasNext()) {
            ClassMetadata classMetadata = this._inits.next();
            classMetadata.initConfigOnUp(this._systemTransaction);
            this.checkWrites();
        }
    }
}

