/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.marshall.MarshallingContext;
import com.db4o.marshall.ReservedBuffer;
import com.db4o.marshall.WriteBuffer;

public class MarshallingBuffer
implements WriteBuffer {
    private static final int SIZE_NEEDED = 8;
    private static final int NO_PARENT = -2147483647;
    private ByteArrayBuffer _delegate;
    private int _lastOffSet;
    private int _addressInParent = -2147483647;
    private List4 _children;
    private FieldMetadata _indexedField;

    public int length() {
        return this.offset();
    }

    public int offset() {
        if (this._delegate == null) {
            return 0;
        }
        return this._delegate.offset();
    }

    public void writeByte(byte b) {
        this.prepareWrite();
        this._delegate.writeByte(b);
    }

    public void writeBytes(byte[] bytes) {
        this.prepareWrite(bytes.length);
        this._delegate.writeBytes(bytes);
    }

    public void writeInt(int i) {
        this.prepareWrite();
        this._delegate.writeInt(i);
    }

    public void writeLong(long l) {
        this.prepareWrite();
        this._delegate.writeLong(l);
    }

    private void prepareWrite() {
        this.prepareWrite(8);
    }

    public void prepareWrite(int sizeNeeded) {
        if (this._delegate == null) {
            this._delegate = new ByteArrayBuffer(sizeNeeded);
        }
        this._lastOffSet = this._delegate.offset();
        if (this.remainingSize() < sizeNeeded) {
            this.resize(sizeNeeded);
        }
    }

    private int remainingSize() {
        return this._delegate.length() - this._delegate.offset();
    }

    private void resize(int sizeNeeded) {
        int newSize = this._delegate.length() * 2;
        if (newSize - this._lastOffSet < sizeNeeded) {
            newSize += sizeNeeded;
        }
        ByteArrayBuffer temp = new ByteArrayBuffer(newSize);
        temp.seek(this._lastOffSet);
        this._delegate.copyTo(temp, 0, 0, this._delegate.length());
        this._delegate = temp;
    }

    public void transferLastWriteTo(MarshallingBuffer other, boolean storeLengthInLink) {
        other.addressInParent(this._lastOffSet, storeLengthInLink);
        int length = this._delegate.offset() - this._lastOffSet;
        other.prepareWrite(length);
        int otherOffset = other._delegate.offset();
        System.arraycopy(this._delegate._buffer, this._lastOffSet, other._delegate._buffer, otherOffset, length);
        this._delegate.seek(this._lastOffSet);
        other._delegate.seek(otherOffset + length);
        other._lastOffSet = otherOffset;
    }

    private void addressInParent(int offset, boolean storeLengthInLink) {
        this._addressInParent = storeLengthInLink ? offset : -offset;
    }

    public void transferContentTo(ByteArrayBuffer buffer) {
        this.transferContentTo(buffer, this.length());
    }

    public void transferContentTo(ByteArrayBuffer buffer, int length) {
        if (this._delegate == null) {
            return;
        }
        System.arraycopy(this._delegate._buffer, 0, buffer._buffer, buffer._offset, length);
        buffer._offset += length;
    }

    public ByteArrayBuffer testDelegate() {
        return this._delegate;
    }

    public MarshallingBuffer addChild() {
        return this.addChild(true, false);
    }

    public MarshallingBuffer addChild(boolean reserveLinkSpace, boolean storeLengthInLink) {
        MarshallingBuffer child = new MarshallingBuffer();
        child.addressInParent(this.offset(), storeLengthInLink);
        this._children = new List4<MarshallingBuffer>(this._children, child);
        if (reserveLinkSpace) {
            this.reserveChildLinkSpace(storeLengthInLink);
        }
        return child;
    }

    public void reserveChildLinkSpace(boolean storeLengthInLink) {
        int length = storeLengthInLink ? 8 : 4;
        this.prepareWrite(length);
        this._delegate.incrementOffset(length);
    }

    public void mergeChildren(MarshallingContext context, int masterAddress, int linkOffset) {
        MarshallingBuffer.mergeChildren(context, masterAddress, this, this, linkOffset);
    }

    private static void mergeChildren(MarshallingContext context, int masterAddress, MarshallingBuffer writeBuffer, MarshallingBuffer parentBuffer, int linkOffset) {
        if (parentBuffer._children == null) {
            return;
        }
        Iterator4Impl i = new Iterator4Impl(parentBuffer._children);
        while (i.moveNext()) {
            MarshallingBuffer.merge(context, masterAddress, writeBuffer, parentBuffer, (MarshallingBuffer)i.current(), linkOffset);
        }
    }

    private static void merge(MarshallingContext context, int masterAddress, MarshallingBuffer writeBuffer, MarshallingBuffer parentBuffer, MarshallingBuffer childBuffer, int linkOffset) {
        int childPosition = writeBuffer.offset();
        writeBuffer.reserve(childBuffer.blockedLength());
        MarshallingBuffer.mergeChildren(context, masterAddress, writeBuffer, childBuffer, linkOffset);
        int savedWriteBufferOffset = writeBuffer.offset();
        writeBuffer.seek(childPosition);
        childBuffer.transferContentTo(writeBuffer._delegate);
        writeBuffer.seek(savedWriteBufferOffset);
        parentBuffer.writeLink(childBuffer, childPosition + linkOffset, childBuffer.unblockedLength());
        childBuffer.writeIndex(context, masterAddress, childPosition + linkOffset);
    }

    public void seek(int offset) {
        this._delegate.seek(offset);
    }

    public ReservedBuffer reserve(int length) {
        this.prepareWrite(length);
        ReservedBuffer reservedBuffer = new ReservedBuffer(){
            private final int reservedOffset;
            {
                this.reservedOffset = MarshallingBuffer.this._delegate.offset();
            }

            public void writeBytes(byte[] bytes) {
                int currentOffset = MarshallingBuffer.this._delegate.offset();
                MarshallingBuffer.this._delegate.seek(this.reservedOffset);
                MarshallingBuffer.this._delegate.writeBytes(bytes);
                MarshallingBuffer.this._delegate.seek(currentOffset);
            }
        };
        this._delegate.seek(this._delegate.offset() + length);
        return reservedBuffer;
    }

    private void writeLink(MarshallingBuffer child, int position, int length) {
        int offset = this.offset();
        this._delegate.seek(child.addressInParent());
        this._delegate.writeInt(position);
        if (child.storeLengthInLink()) {
            this._delegate.writeInt(length);
        }
        this._delegate.seek(offset);
    }

    private void writeIndex(MarshallingContext context, int masterAddress, int position) {
        if (this._indexedField != null) {
            StatefulBuffer buffer = new StatefulBuffer(context.transaction(), this.unblockedLength());
            int blockedPosition = context.container().blockConverter().bytesToBlocks(position);
            int indexID = masterAddress + blockedPosition;
            buffer.setID(indexID);
            buffer.address(indexID);
            this.transferContentTo(buffer, this.unblockedLength());
            this._indexedField.addIndexEntry(context.transaction(), context.objectID(), buffer);
        }
    }

    private int addressInParent() {
        if (!this.hasParent()) {
            throw new IllegalStateException();
        }
        if (this._addressInParent < 0) {
            return -this._addressInParent;
        }
        return this._addressInParent;
    }

    public void debugDecrementLastOffset(int count) {
        this._lastOffSet -= count;
    }

    public boolean hasParent() {
        return this._addressInParent != -2147483647;
    }

    private boolean storeLengthInLink() {
        return this._addressInParent > 0;
    }

    public void requestIndexEntry(FieldMetadata fieldMetadata) {
        this._indexedField = fieldMetadata;
    }

    public MarshallingBuffer checkBlockAlignment(MarshallingContext context, MarshallingBuffer precedingBuffer, IntByRef precedingLength) {
        this._lastOffSet = this.offset();
        if (this.doBlockAlign()) {
            precedingBuffer.blockAlign(context, precedingLength.value);
        }
        if (precedingBuffer != null) {
            precedingLength.value += precedingBuffer.length();
        }
        precedingBuffer = this;
        if (this._children != null) {
            Iterator4Impl i = new Iterator4Impl(this._children);
            while (i.moveNext()) {
                precedingBuffer = ((MarshallingBuffer)i.current()).checkBlockAlignment(context, precedingBuffer, precedingLength);
            }
        }
        return precedingBuffer;
    }

    private void blockAlign(MarshallingContext context, int precedingLength) {
        int totalLength = context.container().blockConverter().blockAlignedBytes(precedingLength + this.length());
        int newLength = totalLength - precedingLength;
        this.blockAlign(newLength);
    }

    public int marshalledLength() {
        int length = this.length();
        if (this._children != null) {
            Iterator4Impl i = new Iterator4Impl(this._children);
            while (i.moveNext()) {
                length += ((MarshallingBuffer)i.current()).marshalledLength();
            }
        }
        return length;
    }

    private void blockAlign(int length) {
        if (this._delegate == null) {
            return;
        }
        if (length > this._delegate.length()) {
            int sizeNeeded = length - this._delegate.offset();
            this.prepareWrite(sizeNeeded);
        }
        this._delegate.seek(length);
    }

    private boolean doBlockAlign() {
        return this.hasParent();
    }

    private int blockedLength() {
        return this.length();
    }

    private int unblockedLength() {
        return this._lastOffSet;
    }
}

