/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.EmbeddedObjectContainer;
import com.db4o.config.Configuration;
import com.db4o.config.FreespaceFiller;
import com.db4o.ext.BackupInProgressException;
import com.db4o.ext.DatabaseClosedException;
import com.db4o.ext.DatabaseReadOnlyException;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.IncompatibleFileFormatException;
import com.db4o.ext.OldFormatException;
import com.db4o.foundation.Runtime4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.slots.Slot;
import com.db4o.io.Bin;
import com.db4o.io.BinConfiguration;
import com.db4o.io.BlockAwareBin;
import com.db4o.io.BlockAwareBinWindow;
import com.db4o.io.Storage;
import com.db4o.io.SynchronizedBin;
import com.db4o.io.ThreadedSyncBin;
import java.io.IOException;

public class IoAdaptedObjectContainer
extends LocalObjectContainer
implements EmbeddedObjectContainer {
    private final String _fileName;
    private BlockAwareBin _file;
    private volatile BlockAwareBin _backupFile;
    private Object _fileLock = new Object();
    private final FreespaceFiller _freespaceFiller;

    IoAdaptedObjectContainer(Configuration config, String fileName) throws OldFormatException {
        super(config);
        this._fileName = fileName;
        this._freespaceFiller = this.createFreespaceFiller();
        this.open();
    }

    protected final void openImpl() throws OldFormatException, DatabaseReadOnlyException {
        boolean lockFile;
        boolean isNew;
        Config4Impl configImpl = this.configImpl();
        Storage storage = configImpl.storage();
        boolean bl = isNew = !storage.exists(this.fileName());
        if (isNew) {
            this.logMsg(14, this.fileName());
            this.checkReadOnly();
            this._handlers.oldEncryptionOff();
        }
        boolean readOnly = configImpl.isReadOnly();
        boolean bl2 = lockFile = configImpl.lockFile() && !readOnly;
        if (this.needsLockFileThread()) {
            Bin fileBin = storage.open(new BinConfiguration(this.fileName(), false, 0L, false, configImpl.blockSize()));
            SynchronizedBin synchronizedBin = new SynchronizedBin(fileBin);
            this._file = new BlockAwareBin(synchronizedBin);
        } else {
            Bin bin = storage.open(new BinConfiguration(this.fileName(), lockFile, 0L, readOnly, configImpl.blockSize()));
            if (configImpl.asynchronousSync()) {
                bin = new ThreadedSyncBin(bin);
            }
            this._file = new BlockAwareBin(bin);
        }
        if (isNew) {
            this.configureNewFile();
            if (configImpl.reservedStorageSpace() > 0) {
                this.reserve(configImpl.reservedStorageSpace());
            }
            this.commitTransaction();
            this.writeHeader(true, false);
        } else {
            this.readThis();
        }
    }

    public void backup(final Storage targetStorage, final String path) throws DatabaseClosedException, Db4oIOException {
        this.withEnvironment(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                Object object2 = IoAdaptedObjectContainer.this._lock;
                synchronized (object2) {
                    IoAdaptedObjectContainer.this.checkClosed();
                    if (IoAdaptedObjectContainer.this._backupFile != null) {
                        throw new BackupInProgressException();
                    }
                    IoAdaptedObjectContainer.this._backupFile = new BlockAwareBin(targetStorage.open(new BinConfiguration(path, true, IoAdaptedObjectContainer.this._file.length(), false, IoAdaptedObjectContainer.this._blockConverter.blocksToBytes(1))));
                }
                long pos = 0L;
                byte[] buffer = new byte[8192];
                while (true) {
                    object = IoAdaptedObjectContainer.this._lock;
                    synchronized (object) {
                        int read = IoAdaptedObjectContainer.this._file.read(pos, buffer);
                        if (read <= 0) {
                            break;
                        }
                        IoAdaptedObjectContainer.this._backupFile.write(pos, buffer, read);
                        pos += (long)read;
                    }
                    Runtime4.sleep(1L);
                }
                object = IoAdaptedObjectContainer.this._lock;
                synchronized (object) {
                    try {
                        IoAdaptedObjectContainer.syncAndClose(IoAdaptedObjectContainer.this._backupFile);
                    }
                    finally {
                        IoAdaptedObjectContainer.this._backupFile = null;
                    }
                }
            }
        });
    }

    public void blockSize(int size) {
        this.createBlockConverter(size);
        this._file.blockSize(size);
    }

    public byte blockSize() {
        return (byte)this._file.blockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownDataStorage() {
        Object object = this._fileLock;
        synchronized (object) {
            try {
                this.closeFileHeader();
            }
            finally {
                this.closeDatabaseFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDatabaseFile() {
        try {
            IoAdaptedObjectContainer.syncAndClose(this._file);
        }
        finally {
            this._file = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncAndClose(Bin bin) {
        if (bin != null) {
            try {
                bin.sync();
            }
            finally {
                bin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFileHeader() {
        try {
            if (this._fileHeader != null) {
                this._fileHeader.close();
            }
        }
        finally {
            this._fileHeader = null;
        }
    }

    public void closeTransaction(Transaction transaction, boolean isSystemTransaction, boolean rollbackOnClose) {
        transaction.close(rollbackOnClose);
    }

    public void commit1(Transaction trans) {
        this.ensureLastSlotWritten();
        super.commit1(trans);
    }

    private void checkXBytes(int newAddress, int newAddressOffset, int length) {
    }

    public long fileLength() {
        return this._file.length();
    }

    public String fileName() {
        return this._fileName;
    }

    public void readBytes(byte[] bytes, int address, int length) throws Db4oIOException {
        this.readBytes(bytes, address, 0, length);
    }

    public void readBytes(byte[] bytes, int address, int addressOffset, int length) throws Db4oIOException {
        if (DTrace.enabled) {
            DTrace.READ_BYTES.logLength((long)(address + addressOffset), length);
        }
        int bytesRead = this._file.blockRead(address, addressOffset, bytes, length);
        this.checkReadCount(bytesRead, length);
    }

    private void checkReadCount(int bytesRead, int expected) {
        if (bytesRead != expected) {
            throw new IncompatibleFileFormatException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserve(int byteCount) throws DatabaseReadOnlyException {
        this.checkReadOnly();
        Object object = this._lock;
        synchronized (object) {
            Slot slot = this.allocateSlot(byteCount);
            this.zeroReservedSlot(slot);
            this.free(slot);
        }
    }

    private void zeroReservedSlot(Slot slot) {
        this.zeroFile(this._file, slot);
        this.zeroFile(this._backupFile, slot);
    }

    private void zeroFile(BlockAwareBin io, Slot slot) {
        int left;
        if (io == null) {
            return;
        }
        byte[] zeroBytes = new byte[1024];
        int offset = 0;
        for (left = slot.length(); left > zeroBytes.length; left -= zeroBytes.length) {
            io.blockWrite(slot.address(), offset, zeroBytes, zeroBytes.length);
            offset += zeroBytes.length;
        }
        if (left > 0) {
            io.blockWrite(slot.address(), offset, zeroBytes, left);
        }
    }

    public void syncFiles() {
        this._file.sync();
    }

    public void syncFiles(Runnable runnable) {
        this._file.sync(runnable);
    }

    public void writeBytes(ByteArrayBuffer buffer, int blockedAddress, int addressOffset) {
        if (DTrace.enabled) {
            DTrace.WRITE_BYTES.logLength((long)(blockedAddress + addressOffset), buffer.length());
        }
        this._file.blockWrite(blockedAddress, addressOffset, buffer._buffer, buffer.length());
        if (this._backupFile != null) {
            this._backupFile.blockWrite(blockedAddress, addressOffset, buffer._buffer, buffer.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overwriteDeletedBytes(int address, int length) {
        if (this._freespaceFiller == null) {
            return;
        }
        if (address > 0 && length > 0) {
            if (DTrace.enabled) {
                DTrace.WRITE_XBYTES.logLength((long)address, length);
            }
            BlockAwareBinWindow window = new BlockAwareBinWindow(this._file, address, length);
            try {
                this.createFreespaceFiller().fill(window);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                window.disable();
            }
        }
    }

    public BlockAwareBin timerFile() {
        return this._file;
    }

    private FreespaceFiller createFreespaceFiller() {
        return this.config().freespaceFiller();
    }

    protected void fatalStorageShutdown() {
        if (this._file != null) {
            this._file.close();
        }
    }

    private static class XByteFreespaceFiller
    implements FreespaceFiller {
        private XByteFreespaceFiller() {
        }

        public void fill(BlockAwareBinWindow io) throws IOException {
            io.write(0, this.xBytes(io.length()));
        }

        private byte[] xBytes(int len) {
            byte[] bytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                bytes[i] = 88;
            }
            return bytes;
        }
    }
}

