/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.DalvikSignatureGenerator;
import com.db4o.foundation.TernaryBool;
import com.db4o.internal.JDK;
import com.db4o.internal.JDKFactory;
import com.db4o.internal.JDK_5;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.core.ReflectConstructor;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Method;

class DalvikVM
extends JDK_5 {
    private TernaryBool supportSkipConstructorCall = TernaryBool.UNSPECIFIED;
    private ObjectFactoryFactory _factory;

    DalvikVM() {
    }

    public ReflectConstructor serializableConstructor(Reflector reflector, final Class clazz) {
        return new ReflectConstructor(){
            private final ObjectFactory factory;
            {
                this.factory = DalvikVM.this.factory().newFactory(clazz);
            }

            public Object newInstance(Object[] parameters) {
                return this.factory.newInstance(clazz);
            }

            public ReflectClass[] getParameterTypes() {
                return new ReflectClass[0];
            }
        };
    }

    boolean supportSkipConstructorCall() {
        this.factory();
        return this.supportSkipConstructorCall.definiteYes();
    }

    private ObjectFactoryFactory factory() {
        if (this.supportSkipConstructorCall.definiteNo()) {
            return null;
        }
        if (this._factory != null) {
            return this._factory;
        }
        try {
            this._factory = new Dalvik2ObjectFactoryFactory();
            this._factory.newFactory(SkipConstructorCheck.class).newInstance(SkipConstructorCheck.class);
            this.supportSkipConstructorCall = TernaryBool.YES;
            return this._factory;
        }
        catch (UnsupportedOperationException e) {
            try {
                this._factory = new Dalvik3ObjectFactoryFactory();
                this._factory.newFactory(SkipConstructorCheck.class).newInstance(SkipConstructorCheck.class);
                this.supportSkipConstructorCall = TernaryBool.YES;
                return this._factory;
            }
            catch (UnsupportedOperationException e2) {
                e2.printStackTrace();
                this.supportSkipConstructorCall = TernaryBool.NO;
                return null;
            }
        }
    }

    public String generateSignature() {
        return DalvikSignatureGenerator.generateSignature();
    }

    private static class Dalvik3ObjectFactory
    implements ObjectFactory {
        private Method _method;
        private final Class _clazz;
        private int _methodId;

        public Dalvik3ObjectFactory(Class clazz, int methodId) {
            this._clazz = clazz;
            this._methodId = methodId;
            try {
                this._method = ObjectStreamClass.class.getDeclaredMethod("newInstance", Class.class, Integer.TYPE);
                this._method.setAccessible(true);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public Object newInstance(Class clazz) {
            if (clazz != this._clazz) {
                throw new IllegalArgumentException();
            }
            try {
                return this._method.invoke(null, this._clazz, this._methodId);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    private static class Dalvik2ObjectFactory
    implements ObjectFactory {
        private Method _method;

        public Dalvik2ObjectFactory() {
            try {
                this._method = ObjectInputStream.class.getDeclaredMethod("newInstance", Class.class, Class.class);
                this._method.setAccessible(true);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public Object newInstance(Class clazz) {
            try {
                return this._method.invoke(null, clazz, Object.class);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    private static class Dalvik3ObjectFactoryFactory
    implements ObjectFactoryFactory {
        private int _methodId;

        public Dalvik3ObjectFactoryFactory() {
            try {
                Method constructorIdMethod = ObjectStreamClass.class.getDeclaredMethod("getConstructorId", Class.class);
                constructorIdMethod.setAccessible(true);
                this._methodId = (Integer)constructorIdMethod.invoke(null, Object.class);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public ObjectFactory newFactory(Class clazz) {
            return new Dalvik3ObjectFactory(clazz, this._methodId);
        }
    }

    private static class Dalvik2ObjectFactoryFactory
    implements ObjectFactoryFactory {
        private final Dalvik2ObjectFactory factory = new Dalvik2ObjectFactory();

        private Dalvik2ObjectFactoryFactory() {
        }

        public ObjectFactory newFactory(Class clazz) {
            return this.factory;
        }
    }

    private static interface ObjectFactoryFactory {
        public ObjectFactory newFactory(Class var1);
    }

    private static interface ObjectFactory {
        public Object newInstance(Class var1);
    }

    public static class SkipConstructorCheck {
        public SkipConstructorCheck() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Factory
    implements JDKFactory {
        public JDK tryToCreate() {
            if (!"Dalvik".equals(System.getProperty("java.vm.name"))) {
                return null;
            }
            return new DalvikVM();
        }
    }
}

