/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.main;

import com.db4o.foundation.io.Directory4;
import com.db4o.foundation.io.Path4;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.main.Db4oFileInstrumentor;
import com.db4o.instrumentation.util.ZipFileCreation;
import com.db4o.instrumentation.util.ZipFileExtraction;
import java.io.File;
import java.io.IOException;

public class Db4oJarEnhancer {
    private final Db4oFileInstrumentor _fileEnhancer;

    public Db4oJarEnhancer(BloatClassEdit classEdit) {
        this._fileEnhancer = new Db4oFileInstrumentor(classEdit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enhance(File inputJar, File outputJar, String[] classPath) throws Exception {
        File workingDir = this.tempDir(inputJar.getName());
        try {
            this.extractJarTo(inputJar, workingDir);
            this.enhance(workingDir, classPath);
            this.makeJarFromDirectory(workingDir, outputJar);
        }
        finally {
            this.deleteDirectory(workingDir);
        }
    }

    private void deleteDirectory(File workingDir) {
        Directory4.delete(workingDir.getAbsolutePath(), true);
    }

    private void enhance(File workingDir, String[] classPath) throws Exception {
        this._fileEnhancer.enhance(workingDir, workingDir, classPath);
    }

    private File tempDir(String name) {
        return new File(Path4.combine(Path4.getTempPath(), name + "-working"));
    }

    private void extractJarTo(File inputJar, File workingDir) throws IOException {
        new ZipFileExtraction(inputJar, workingDir);
    }

    private void makeJarFromDirectory(File workingDir, File outputJar) throws IOException {
        new ZipFileCreation(workingDir, outputJar);
    }
}

