/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.main;

import EDU.purdue.cs.bloat.context.BloatingClassLoader;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import com.db4o.instrumentation.classfilter.AcceptAllClassesFilter;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.core.ClassFilter;
import com.db4o.instrumentation.util.BloatUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class BloatInstrumentingClassLoader
extends BloatingClassLoader {
    private final Map _cache = new HashMap();
    private final ClassFilter _filter;
    private final BloatClassEdit _edit;
    private final BloatLoaderContext _loaderContext = new BloatLoaderContext(this.getEditorContext());
    private final ClassLoader _filterLoader;

    public BloatInstrumentingClassLoader(URL[] urls, ClassLoader parent, BloatClassEdit edit) {
        this(urls, parent, new AcceptAllClassesFilter(), edit);
    }

    public BloatInstrumentingClassLoader(URL[] urls, ClassLoader parent, ClassFilter filter, BloatClassEdit edit) {
        super(urls, parent);
        this._filter = filter;
        this._edit = edit;
        this._filterLoader = new URLClassLoader(urls, parent);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this._cache.containsKey(name)) {
            return (Class)this._cache.get(name);
        }
        if (this.mustDelegate(name)) {
            try {
                Class<?> originalClazz = this.getParent().loadClass(name);
                return originalClazz;
            }
            catch (ClassNotFoundException exc) {
                // empty catch block
            }
        }
        Class clazz = this.shouldLoadRaw(name) ? this.findRawClass(name) : this.findClass(name);
        this._cache.put(clazz.getName(), clazz);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected boolean mustDelegate(String name) {
        return BloatUtil.isPlatformClassName(name) || name.startsWith("com.db4o.") && name.indexOf("test.") < 0 && name.indexOf("samples.") < 0;
    }

    protected boolean shouldLoadRaw(String name) throws ClassNotFoundException {
        if (this.mustDelegate(name)) {
            return true;
        }
        Class<?> bogusClazz = this._filterLoader.loadClass(name);
        return !this._filter.accept(bogusClazz);
    }

    private Class findRawClass(String className) throws ClassNotFoundException {
        try {
            String resourcePath = className.replace('.', '/') + ".class";
            InputStream resourceStream = this.getResourceAsStream(resourcePath);
            ByteArrayOutputStream rawByteStream = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int bytesread = 0;
            while ((bytesread = resourceStream.read(buf)) >= 0) {
                rawByteStream.write(buf, 0, bytesread);
            }
            resourceStream.close();
            byte[] rawBytes = rawByteStream.toByteArray();
            return super.defineClass(className, rawBytes, 0, rawBytes.length);
        }
        catch (Exception exc) {
            throw new ClassNotFoundException(className, exc);
        }
    }

    protected void bloat(ClassEditor ce) {
        this._edit.enhance(ce, this.getParent(), this._loaderContext);
    }
}

