/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.file;

import com.db4o.instrumentation.file.InstrumentationClassSource;
import com.db4o.instrumentation.util.BloatUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileInstrumentationClassSource
implements Comparable,
InstrumentationClassSource {
    private final File _root;
    private final File _file;

    public FileInstrumentationClassSource(File root, File file) {
        this._root = root;
        this._file = file;
    }

    public File root() {
        return this._root;
    }

    public File file() {
        return this._file;
    }

    public String className() throws IOException {
        return BloatUtil.classNameForPath(this.classPath());
    }

    private String classPath() throws IOException {
        return this._file.getCanonicalPath().substring(this._root.getCanonicalPath().length() + 1);
    }

    public File targetPath(File targetBase) throws IOException {
        return new File(targetBase, this.classPath());
    }

    public int hashCode() {
        return 43 * this._root.hashCode() + this._file.hashCode();
    }

    public InputStream inputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FileInstrumentationClassSource other = (FileInstrumentationClassSource)obj;
        return this._root.equals(other._root) && this._file.equals(other._file);
    }

    public int compareTo(Object o) {
        return this._file.compareTo(((FileInstrumentationClassSource)o)._file);
    }

    public String toString() {
        return this._file + " [" + this._root + "]";
    }

    public File sourceFile() {
        return this._file;
    }
}

