/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.CancellableVisitor4;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.ShallowClone;
import com.db4o.foundation.Visitable;
import com.db4o.foundation.Visitor4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Tree<T>
implements ShallowClone,
DeepClone,
Visitable<T> {
    public Tree<T> _preceding;
    public int _size = 1;
    public Tree<T> _subsequent;

    public static final <T, V extends Tree<T>> V add(V oldTree, V newTree) {
        if (oldTree == null) {
            return newTree;
        }
        return oldTree.add(newTree);
    }

    public final <V extends Tree<T>> V add(V newNode) {
        return this.add(newNode, this.compare(newNode));
    }

    /*
     * Enabled aggressive block sorting
     */
    public <V extends Tree<T>> V add(V newNode, int cmp) {
        if (cmp < 0) {
            if (this._subsequent == null) {
                this._subsequent = newNode;
                ++this._size;
                return (V)this;
            }
            this._subsequent = this._subsequent.add(newNode);
            if (this._preceding != null) return (V)this.balance();
            return (V)this.rotateLeft();
        }
        if (cmp <= 0) {
            if (!newNode.duplicates()) return (V)newNode.onAttemptToAddDuplicate(this);
        }
        if (this._preceding == null) {
            this._preceding = newNode;
            ++this._size;
            return (V)this;
        }
        this._preceding = this._preceding.add(newNode);
        if (this._subsequent != null) return (V)this.balance();
        return (V)this.rotateRight();
    }

    public Tree addedOrExisting() {
        if (this.wasAddedToTree()) {
            return this;
        }
        return this._preceding;
    }

    public boolean wasAddedToTree() {
        return this._size != 0;
    }

    public final Tree balance() {
        int cmp = this._subsequent.nodes() - this._preceding.nodes();
        if (cmp < -2) {
            return this.rotateRight();
        }
        if (cmp > 2) {
            return this.rotateLeft();
        }
        this.setSizeOwnPrecedingSubsequent();
        return this;
    }

    public Tree balanceCheckNulls() {
        if (this._subsequent == null) {
            if (this._preceding == null) {
                this.setSizeOwn();
                return this;
            }
            return this.rotateRight();
        }
        if (this._preceding == null) {
            return this.rotateLeft();
        }
        return this.balance();
    }

    public void calculateSize() {
        if (this._preceding == null) {
            if (this._subsequent == null) {
                this.setSizeOwn();
            } else {
                this.setSizeOwnSubsequent();
            }
        } else if (this._subsequent == null) {
            this.setSizeOwnPreceding();
        } else {
            this.setSizeOwnPrecedingSubsequent();
        }
    }

    public abstract int compare(Tree var1);

    public static Tree deepClone(Tree a_tree, Object a_param) {
        if (a_tree == null) {
            return null;
        }
        Tree newNode = (Tree)a_tree.deepClone(a_param);
        newNode._size = a_tree._size;
        newNode._preceding = Tree.deepClone(a_tree._preceding, a_param);
        newNode._subsequent = Tree.deepClone(a_tree._subsequent, a_param);
        return newNode;
    }

    @Override
    public Object deepClone(Object a_param) {
        return this.shallowClone();
    }

    public boolean duplicates() {
        return true;
    }

    public final Tree filter(Predicate4 a_filter) {
        if (this._preceding != null) {
            this._preceding = this._preceding.filter(a_filter);
        }
        if (this._subsequent != null) {
            this._subsequent = this._subsequent.filter(a_filter);
        }
        if (!a_filter.match(this)) {
            return this.remove();
        }
        return this;
    }

    public static final <T> Tree<T> find(Tree<T> inTree, Tree<T> template) {
        if (inTree == null) {
            return null;
        }
        return inTree.find(template);
    }

    public final Tree<T> find(Tree<T> template) {
        int comparisonResult;
        Tree<T> current = this;
        do {
            if ((comparisonResult = current.compare(template)) != 0) continue;
            return current;
        } while ((current = comparisonResult < 0 ? current._subsequent : current._preceding) != null);
        return null;
    }

    public static final Tree findGreaterOrEqual(Tree a_in, Tree a_finder) {
        if (a_in == null) {
            return null;
        }
        int cmp = a_in.compare(a_finder);
        if (cmp == 0) {
            return a_in;
        }
        if (cmp > 0) {
            Tree node = Tree.findGreaterOrEqual(a_in._preceding, a_finder);
            if (node != null) {
                return node;
            }
            return a_in;
        }
        return Tree.findGreaterOrEqual(a_in._subsequent, a_finder);
    }

    public static final Tree findSmaller(Tree a_in, Tree a_node) {
        if (a_in == null) {
            return null;
        }
        int cmp = a_in.compare(a_node);
        if (cmp < 0) {
            Tree node = Tree.findSmaller(a_in._subsequent, a_node);
            if (node != null) {
                return node;
            }
            return a_in;
        }
        return Tree.findSmaller(a_in._preceding, a_node);
    }

    public final Tree<T> first() {
        if (this._preceding == null) {
            return this;
        }
        return this._preceding.first();
    }

    public static Tree last(Tree tree) {
        if (tree == null) {
            return null;
        }
        return tree.last();
    }

    public final Tree last() {
        if (this._subsequent == null) {
            return this;
        }
        return this._subsequent.last();
    }

    public Tree onAttemptToAddDuplicate(Tree oldNode) {
        this._size = 0;
        this._preceding = oldNode;
        return oldNode;
    }

    public int nodes() {
        return this._size;
    }

    public int ownSize() {
        return 1;
    }

    public Tree remove() {
        if (this._subsequent != null && this._preceding != null) {
            this._subsequent = super.rotateSmallestUp();
            this._subsequent._preceding = this._preceding;
            this._subsequent.calculateSize();
            return this._subsequent;
        }
        if (this._subsequent != null) {
            return this._subsequent;
        }
        return this._preceding;
    }

    public void removeChildren() {
        this._preceding = null;
        this._subsequent = null;
        this.setSizeOwn();
    }

    public Tree removeFirst() {
        if (this._preceding == null) {
            return this._subsequent;
        }
        this._preceding = this._preceding.removeFirst();
        this.calculateSize();
        return this;
    }

    public static Tree removeLike(Tree from, Tree a_find) {
        if (from == null) {
            return null;
        }
        return from.removeLike(a_find);
    }

    public final <V extends Tree<T>> V removeLike(V a_find) {
        int cmp = this.compare(a_find);
        if (cmp == 0) {
            return (V)this.remove();
        }
        if (cmp > 0) {
            if (this._preceding != null) {
                this._preceding = this._preceding.removeLike(a_find);
            }
        } else if (this._subsequent != null) {
            this._subsequent = this._subsequent.removeLike(a_find);
        }
        this.calculateSize();
        return (V)this;
    }

    public final Tree removeNode(Tree a_tree) {
        if (this == a_tree) {
            return this.remove();
        }
        int cmp = this.compare(a_tree);
        if (cmp >= 0 && this._preceding != null) {
            this._preceding = this._preceding.removeNode(a_tree);
        }
        if (cmp <= 0 && this._subsequent != null) {
            this._subsequent = this._subsequent.removeNode(a_tree);
        }
        this.calculateSize();
        return this;
    }

    public final Tree rotateLeft() {
        Tree<T> tree = this._subsequent;
        this._subsequent = tree._preceding;
        this.calculateSize();
        tree._preceding = this;
        if (tree._subsequent == null) {
            tree.setSizeOwnPlus(this);
        } else {
            tree.setSizeOwnPlus(this, tree._subsequent);
        }
        return tree;
    }

    public final Tree rotateRight() {
        Tree<T> tree = this._preceding;
        this._preceding = tree._subsequent;
        this.calculateSize();
        tree._subsequent = this;
        if (tree._preceding == null) {
            tree.setSizeOwnPlus(this);
        } else {
            tree.setSizeOwnPlus(this, tree._preceding);
        }
        return tree;
    }

    private final Tree rotateSmallestUp() {
        if (this._preceding != null) {
            this._preceding = super.rotateSmallestUp();
            return this.rotateRight();
        }
        return this;
    }

    public final void setSizeOwn() {
        this._size = this.ownSize();
    }

    public final void setSizeOwnPrecedingSubsequent() {
        this._size = this.ownSize() + this._preceding._size + this._subsequent._size;
    }

    public final void setSizeOwnPreceding() {
        this._size = this.ownSize() + this._preceding._size;
    }

    public final void setSizeOwnSubsequent() {
        this._size = this.ownSize() + this._subsequent._size;
    }

    public final void setSizeOwnPlus(Tree tree) {
        this._size = this.ownSize() + tree._size;
    }

    public final void setSizeOwnPlus(Tree tree1, Tree tree2) {
        this._size = this.ownSize() + tree1._size + tree2._size;
    }

    public static int size(Tree a_tree) {
        if (a_tree == null) {
            return 0;
        }
        return a_tree.size();
    }

    public int size() {
        return this._size;
    }

    public static final void traverse(Tree tree, Visitor4 visitor) {
        if (tree == null) {
            return;
        }
        tree.traverse(visitor);
    }

    public static void traverse(Tree tree, Tree startingNode, CancellableVisitor4 visitor) {
        if (tree == null) {
            return;
        }
        tree.traverse(startingNode, visitor);
    }

    private boolean traverse(Tree startingNode, CancellableVisitor4 visitor) {
        if (startingNode != null) {
            int cmp = this.compare(startingNode);
            if (cmp < 0) {
                if (this._subsequent != null) {
                    return super.traverse(startingNode, visitor);
                }
                return true;
            }
            if (cmp > 0 && this._preceding != null && !super.traverse(startingNode, visitor)) {
                return false;
            }
        } else if (this._preceding != null && !super.traverse(null, visitor)) {
            return false;
        }
        if (!visitor.visit(this)) {
            return false;
        }
        return this._subsequent == null || super.traverse(null, visitor);
    }

    public final <V extends Tree<T>> void traverse(Visitor4<V> visitor) {
        if (this._preceding != null) {
            this._preceding.traverse(visitor);
        }
        visitor.visit(this);
        if (this._subsequent != null) {
            this._subsequent.traverse(visitor);
        }
    }

    public final void traverseFromLeaves(Visitor4 a_visitor) {
        if (this._preceding != null) {
            this._preceding.traverseFromLeaves(a_visitor);
        }
        if (this._subsequent != null) {
            this._subsequent.traverseFromLeaves(a_visitor);
        }
        a_visitor.visit(this);
    }

    protected Tree shallowCloneInternal(Tree tree) {
        tree._preceding = this._preceding;
        tree._size = this._size;
        tree._subsequent = this._subsequent;
        return tree;
    }

    @Override
    public Object shallowClone() {
        throw new NotImplementedException();
    }

    public abstract T key();

    public Object root() {
        return this;
    }

    @Override
    public void accept(final Visitor4<T> visitor) {
        this.traverse(new Visitor4(){

            public void visit(Object obj) {
                Tree tree = (Tree)obj;
                visitor.visit(tree.key());
            }
        });
    }
}

