/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.BlockingQueue;
import com.db4o.foundation.BlockingQueueStoppedException;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.PausableBlockingQueue4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PausableBlockingQueue<T>
extends BlockingQueue<T>
implements PausableBlockingQueue4<T> {
    private volatile boolean _paused = false;

    @Override
    public boolean pause() {
        if (this._paused) {
            return false;
        }
        this._paused = true;
        return true;
    }

    @Override
    public boolean resume() {
        return this._lock.run(new Closure4<Boolean>(){

            @Override
            public Boolean run() {
                if (!PausableBlockingQueue.this._paused) {
                    return false;
                }
                PausableBlockingQueue.this._paused = false;
                PausableBlockingQueue.this._lock.awake();
                return true;
            }
        });
    }

    @Override
    public boolean isPaused() {
        return this._paused;
    }

    @Override
    protected boolean unsafeWaitForNext(long timeout) throws BlockingQueueStoppedException {
        boolean hasNext = super.unsafeWaitForNext(timeout);
        while (this._paused && !this._stopped) {
            this._lock.snooze(timeout);
        }
        if (this._stopped) {
            throw new BlockingQueueStoppedException();
        }
        return hasNext;
    }

    @Override
    public T tryNext() {
        return this._lock.run(new Closure4<T>(){

            @Override
            public T run() {
                return PausableBlockingQueue.this.isPaused() ? null : (PausableBlockingQueue.this.hasNext() ? PausableBlockingQueue.this.next() : null);
            }
        });
    }
}

