/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.Queue4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonblockingQueue<T>
implements Queue4<T> {
    private List4<T> _insertionPoint;
    private List4<T> _next;

    @Override
    public final void add(T obj) {
        List4<T> newNode = new List4<T>(null, obj);
        if (this._insertionPoint == null) {
            this._next = newNode;
        } else {
            this._insertionPoint._next = newNode;
        }
        this._insertionPoint = newNode;
    }

    @Override
    public final T next() {
        if (this._next == null) {
            return null;
        }
        Object ret = this._next._element;
        this.removeNext();
        return ret;
    }

    private void removeNext() {
        this._next = this._next._next;
        if (this._next == null) {
            this._insertionPoint = null;
        }
    }

    @Override
    public T nextMatching(Predicate4<T> condition) {
        if (null == condition) {
            throw new ArgumentNullException();
        }
        List4<T> current = this._next;
        List4<T> previous = null;
        while (null != current) {
            Object element = current._element;
            if (condition.match(element)) {
                if (previous == null) {
                    this.removeNext();
                } else {
                    previous._next = current._next;
                }
                return element;
            }
            previous = current;
            current = current._next;
        }
        return null;
    }

    @Override
    public final boolean hasNext() {
        return this._next != null;
    }

    @Override
    public Iterator4<T> iterator() {
        final List4<T> origInsertionPoint = this._insertionPoint;
        final List4<T> origNext = this._next;
        return new Iterator4Impl<T>(this._next){

            @Override
            public boolean moveNext() {
                if (origInsertionPoint != NonblockingQueue.this._insertionPoint || origNext != NonblockingQueue.this._next) {
                    throw new IllegalStateException();
                }
                return super.moveNext();
            }
        };
    }
}

