/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.NotImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularLongBuffer4
implements Iterable4<Long> {
    private static final int EMPTY = -1;
    private final long[] _buffer;
    private int _head;
    private int _tail;

    public CircularLongBuffer4(int size) {
        this._buffer = new long[size + 1];
    }

    public int size() {
        return this.index(this._tail - this._head);
    }

    public void addFirst(long value) {
        int newHead = this.circularIndex(this._head - 1);
        if (newHead == this._tail) {
            throw new IllegalStateException();
        }
        this._head = newHead;
        this._buffer[this.index((int)this._head)] = value;
    }

    private int circularIndex(int index) {
        return index % this._buffer.length;
    }

    private int index(int i) {
        return i < 0 ? this._buffer.length + i : i;
    }

    public long removeLast() {
        this.assertNotEmpty();
        this._tail = this.circularIndex(this._tail - 1);
        return this.erase(this._tail);
    }

    private void assertNotEmpty() {
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    public boolean isEmpty() {
        return this.index(this._head) == this.index(this._tail);
    }

    public boolean isFull() {
        return this.circularIndex(this._head - 1) == this._tail;
    }

    public long removeFirst() {
        this.assertNotEmpty();
        long erased = this.erase(this._head);
        this._head = this.circularIndex(this._head + 1);
        return erased;
    }

    private long erase(int index) {
        int bufferIndex = this.index(index);
        long erasedValue = this._buffer[bufferIndex];
        this._buffer[bufferIndex] = -1L;
        return erasedValue;
    }

    public boolean remove(long value) {
        int idx = this.indexOf(value);
        if (idx >= 0) {
            this.removeAt(idx);
            return true;
        }
        return false;
    }

    public boolean contains(long value) {
        return this.indexOf(value) >= 0;
    }

    private int indexOf(long value) {
        int current = this.index(this._head);
        int tail = this.index(this._tail);
        while (current != tail && value != this._buffer[current]) {
            current = this.circularIndex(current + 1);
        }
        return current == tail ? -1 : current;
    }

    private void removeAt(int index) {
        if (this.index(this._tail - 1) == index) {
            this.removeLast();
            return;
        }
        if (index == this.index(this._head)) {
            this.removeFirst();
            return;
        }
        int current = index;
        int tail = this.index(this._tail);
        while (current != tail) {
            int next = this.circularIndex(current + 1);
            this._buffer[current] = this._buffer[next];
            current = next;
        }
        this._tail = this.circularIndex(this._tail - 1);
    }

    @Override
    public Iterator4 iterator() {
        final int tail = this.index(this._tail);
        final int head = this.index(this._head);
        return new Iterator4(){
            private int _index;
            private Object _current;
            {
                this._index = head;
                this._current = Iterators.NO_ELEMENT;
            }

            public Object current() {
                if (this._current == Iterators.NO_ELEMENT) {
                    throw new IllegalStateException();
                }
                return this._current;
            }

            public boolean moveNext() {
                if (this._index == tail) {
                    return false;
                }
                this._current = CircularLongBuffer4.this._buffer[this._index];
                this._index = CircularLongBuffer4.this.circularIndex(this._index + 1);
                return true;
            }

            public void reset() {
                throw new NotImplementedException();
            }
        };
    }
}

