/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.filestats;

import com.db4o.filestats.SlotMap;
import com.db4o.foundation.ByRef;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.slots.Slot;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlotMapImpl
implements SlotMap {
    private TreeIntObject<Slot> _slots = null;
    private final long _fileLength;

    public SlotMapImpl(long fileLength) {
        this._fileLength = fileLength;
    }

    @Override
    public void add(Slot slot) {
        this._slots = Tree.add(this._slots, new TreeIntObject<Slot>(slot.address(), slot));
    }

    @Override
    public List<Slot> merged() {
        final ArrayList<Slot> mergedSlots = new ArrayList<Slot>();
        final ByRef<Slot> mergedSlot = ByRef.newInstance(new Slot(0, 0));
        Tree.traverse(this._slots, new Visitor4<TreeIntObject<Slot>>(){

            @Override
            public void visit(TreeIntObject<Slot> node) {
                Slot curSlot = (Slot)node._object;
                if (((Slot)mergedSlot.value).address() + ((Slot)mergedSlot.value).length() == curSlot.address()) {
                    mergedSlot.value = new Slot(((Slot)mergedSlot.value).address(), ((Slot)mergedSlot.value).length() + curSlot.length());
                } else {
                    mergedSlots.add(mergedSlot.value);
                    mergedSlot.value = curSlot;
                }
            }
        });
        mergedSlots.add((Slot)mergedSlot.value);
        return mergedSlots;
    }

    @Override
    public List<Slot> gaps(long length) {
        List<Slot> merged = this.merged();
        ArrayList<Slot> gaps = new ArrayList<Slot>();
        if (merged.size() == 0) {
            return gaps;
        }
        boolean isFirst = true;
        Slot prevSlot = null;
        for (Slot curSlot : merged) {
            if (isFirst) {
                prevSlot = curSlot;
                if (prevSlot.address() > 0) {
                    gaps.add(new Slot(0, prevSlot.address()));
                }
                isFirst = false;
                continue;
            }
            int gapStart = prevSlot.address() + prevSlot.length();
            gaps.add(new Slot(gapStart, curSlot.address() - gapStart));
            prevSlot = curSlot;
        }
        int afterlast = prevSlot.address() + prevSlot.length();
        if ((long)afterlast < length) {
            gaps.add(new Slot(afterlast, (int)(length - (long)afterlast)));
        }
        return gaps;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("SLOTS:\n");
        this.logSlots(this.merged(), str);
        str.append("GAPS:");
        this.logSlots(this.gaps(this._fileLength), str);
        return str.toString();
    }

    private void logSlots(Iterable<Slot> slots, StringBuffer str) {
        int totalLength = 0;
        for (Slot gap : slots) {
            totalLength += gap.length();
            str.append(gap).append("\n");
        }
        str.append("TOTAL: ").append(totalLength).append("\n");
    }
}

