/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.filestats;

import com.db4o.Db4oEmbedded;
import com.db4o.EmbeddedObjectContainer;
import com.db4o.ObjectContainer;
import com.db4o.config.EmbeddedConfiguration;
import com.db4o.filestats.BigSetMiscCollector;
import com.db4o.filestats.ClassNode;
import com.db4o.filestats.ClassUsageStats;
import com.db4o.filestats.FileUsageStats;
import com.db4o.filestats.MiscCollector;
import com.db4o.filestats.NullSlotMap;
import com.db4o.filestats.SlotMap;
import com.db4o.filestats.SlotMapImpl;
import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.LongByRef;
import com.db4o.foundation.Pair;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.BlockConverter;
import com.db4o.internal.BlockSizeBlockConverter;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.CommitTimestampSupport;
import com.db4o.internal.DisabledBlockConverter;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.Reflection4;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.collections.BigSet;
import com.db4o.internal.fileheader.FileHeaderVariablePart2;
import com.db4o.internal.freespace.BTreeFreespaceManager;
import com.db4o.internal.freespace.BlockAwareFreespaceManager;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.freespace.InMemoryFreespaceManager;
import com.db4o.internal.ids.IdSystem;
import com.db4o.internal.slots.Slot;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUsageStatsCollector {
    private final Map<String, MiscCollector> MISC_COLLECTORS = new HashMap<String, MiscCollector>();
    private final LocalObjectContainer _db;
    private FileUsageStats _stats;
    private BlockConverter _blockConverter;
    private final SlotMap _slots;

    private void registerBigSetCollector() {
        this.MISC_COLLECTORS.put(BigSet.class.getName(), new BigSetMiscCollector());
    }

    public static void main(String[] args) {
        String dbPath = args[0];
        boolean collectSlots = args.length > 1 && "true".equals(args[1]);
        System.out.println(dbPath + ": " + new File(dbPath).length());
        FileUsageStats stats = FileUsageStatsCollector.runStats(dbPath, collectSlots);
        System.out.println(stats);
    }

    public static FileUsageStats runStats(String dbPath) {
        return FileUsageStatsCollector.runStats(dbPath, false);
    }

    public static FileUsageStats runStats(String dbPath, boolean collectSlots) {
        return FileUsageStatsCollector.runStats(dbPath, collectSlots, Db4oEmbedded.newConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileUsageStats runStats(String dbPath, boolean collectSlots, EmbeddedConfiguration config) {
        EmbeddedObjectContainer db = Db4oEmbedded.openFile(config, dbPath);
        try {
            FileUsageStats fileUsageStats = new FileUsageStatsCollector(db, collectSlots).collectStats();
            return fileUsageStats;
        }
        finally {
            db.close();
        }
    }

    public FileUsageStatsCollector(ObjectContainer db, boolean collectSlots) {
        this.registerBigSetCollector();
        this._db = (LocalObjectContainer)db;
        byte blockSize = this._db.blockSize();
        this._blockConverter = blockSize > 1 ? new BlockSizeBlockConverter(blockSize) : new DisabledBlockConverter();
        this._slots = collectSlots ? new SlotMapImpl(this._db.fileLength()) : new NullSlotMap();
    }

    public FileUsageStats collectStats() {
        this._stats = new FileUsageStats(this._db.fileLength(), this.fileHeaderUsage(), this.idSystemUsage(), this.freespace(), this.classMetadataUsage(), this.freespaceUsage(), this.uuidUsage(), this._slots, this.commitTimestampUsage());
        Set<ClassNode> classRoots = ClassNode.buildHierarchy(this._db.classCollection());
        for (ClassNode classRoot : classRoots) {
            this.collectClassSlots(classRoot.classMetadata());
            this.collectClassStats(this._stats, classRoot);
        }
        return this._stats;
    }

    private long collectClassStats(FileUsageStats stats, ClassNode classNode) {
        long subClassSlotUsage = 0L;
        for (ClassNode curSubClass : classNode.subClasses()) {
            subClassSlotUsage += this.collectClassStats(stats, curSubClass);
        }
        ClassMetadata clazz = classNode.classMetadata();
        long classIndexUsage = 0L;
        if (clazz.hasClassIndex()) {
            classIndexUsage = this.bTreeUsage(((BTreeClassIndexStrategy)clazz.index()).btree());
        }
        long fieldIndexUsage = this.fieldIndexUsage(clazz);
        InstanceUsage instanceUsage = this.classSlotUsage(clazz);
        long totalSlotUsage = instanceUsage.slotUsage;
        long ownSlotUsage = totalSlotUsage - subClassSlotUsage;
        ClassUsageStats classStats = new ClassUsageStats(clazz.getName(), ownSlotUsage, classIndexUsage, fieldIndexUsage, instanceUsage.miscUsage);
        stats.addClassStats(classStats);
        return totalSlotUsage;
    }

    private long fieldIndexUsage(ClassMetadata classMetadata) {
        final LongByRef usage = new LongByRef();
        classMetadata.traverseDeclaredFields(new Procedure4<FieldMetadata>(){

            @Override
            public void apply(FieldMetadata field) {
                if (field.isVirtual() || !field.hasIndex()) {
                    return;
                }
                usage.value += FileUsageStatsCollector.this.bTreeUsage(field.getIndex(FileUsageStatsCollector.this._db.systemTransaction()));
            }
        });
        return usage.value;
    }

    private long bTreeUsage(BTree btree) {
        return FileUsageStatsCollector.bTreeUsage(this._db, btree, this._slots);
    }

    static long bTreeUsage(LocalObjectContainer db, BTree btree, SlotMap slotMap) {
        return FileUsageStatsCollector.bTreeUsage(db.systemTransaction(), db.idSystem(), btree, slotMap);
    }

    private static long bTreeUsage(Transaction transaction, IdSystem idSystem, BTree btree, SlotMap slotMap) {
        Iterator4 nodeIter = btree.allNodeIds(transaction);
        Slot btreeSlot = idSystem.committedSlot(btree.getID());
        slotMap.add(btreeSlot);
        long usage = btreeSlot.length();
        while (nodeIter.moveNext()) {
            Integer curNodeId = (Integer)nodeIter.current();
            Slot slot = idSystem.committedSlot(curNodeId);
            slotMap.add(slot);
            usage += (long)slot.length();
        }
        return usage;
    }

    private InstanceUsage classSlotUsage(ClassMetadata clazz) {
        if (!clazz.hasClassIndex()) {
            return new InstanceUsage(0L, 0L);
        }
        final MiscCollector miscCollector = this.MISC_COLLECTORS.get(clazz.getName());
        final LongByRef slotUsage = new LongByRef();
        final LongByRef miscUsage = new LongByRef();
        BTreeClassIndexStrategy index = (BTreeClassIndexStrategy)clazz.index();
        index.traverseAll(this._db.systemTransaction(), new Visitor4<Integer>(){

            @Override
            public void visit(Integer id) {
                slotUsage.value += (long)FileUsageStatsCollector.this.slotSizeForId(id);
                if (miscCollector != null) {
                    miscUsage.value += miscCollector.collectFor(FileUsageStatsCollector.this._db, id, FileUsageStatsCollector.this._slots);
                }
            }
        });
        return new InstanceUsage(slotUsage.value, miscUsage.value);
    }

    private void collectClassSlots(ClassMetadata clazz) {
        if (!clazz.hasClassIndex()) {
            return;
        }
        BTreeClassIndexStrategy index = (BTreeClassIndexStrategy)clazz.index();
        index.traverseAll(this._db.systemTransaction(), new Visitor4<Integer>(){

            @Override
            public void visit(Integer id) {
                FileUsageStatsCollector.this._slots.add(FileUsageStatsCollector.this.slot(id));
            }
        });
    }

    private long freespace() {
        this._db.freespaceManager().traverse(new Visitor4<Slot>(){

            @Override
            public void visit(Slot slot) {
                FileUsageStatsCollector.this._slots.add(slot);
            }
        });
        return this._db.freespaceManager().totalFreespace();
    }

    private long freespaceUsage() {
        return this.freespaceUsage(this._db.freespaceManager());
    }

    private long freespaceUsage(FreespaceManager fsm) {
        if (fsm instanceof InMemoryFreespaceManager) {
            return 0L;
        }
        if (fsm instanceof BTreeFreespaceManager) {
            return this.bTreeUsage((BTree)FileUsageStatsCollector.fieldValue(fsm, "_slotsByAddress")) + this.bTreeUsage((BTree)FileUsageStatsCollector.fieldValue(fsm, "_slotsByLength"));
        }
        if (fsm instanceof BlockAwareFreespaceManager) {
            return this.freespaceUsage((FreespaceManager)FileUsageStatsCollector.fieldValue(fsm, "_delegate"));
        }
        throw new IllegalStateException("Unknown freespace manager: " + fsm);
    }

    private long idSystemUsage() {
        final IntByRef usage = new IntByRef();
        this._db.idSystem().traverseOwnSlots(new Procedure4<Pair<Integer, Slot>>(){

            @Override
            public void apply(Pair<Integer, Slot> idSlot) {
                Slot slot = (Slot)idSlot.second;
                usage.value += slot.length();
                FileUsageStatsCollector.this._slots.add(slot);
            }
        });
        return usage.value;
    }

    private long classMetadataUsage() {
        Slot classRepositorySlot = this.slot(this._db.classCollection().getID());
        this._slots.add(classRepositorySlot);
        long usage = classRepositorySlot.length();
        Iterator4 classIdIter = this._db.classCollection().ids();
        while (classIdIter.moveNext()) {
            int curClassId = (Integer)classIdIter.current();
            Slot classSlot = this.slot(curClassId);
            this._slots.add(classSlot);
            usage += (long)classSlot.length();
        }
        return usage;
    }

    private long fileHeaderUsage() {
        int headerLength = this._db.getFileHeader().length();
        int usage = this._blockConverter.blockAlignedBytes(headerLength);
        FileHeaderVariablePart2 variablePart = (FileHeaderVariablePart2)FileUsageStatsCollector.fieldValue(this._db.getFileHeader(), "_variablePart");
        this._slots.add(new Slot(0, headerLength));
        this._slots.add(new Slot(variablePart.address(), variablePart.marshalledLength()));
        return usage += this._blockConverter.blockAlignedBytes(variablePart.marshalledLength());
    }

    private long uuidUsage() {
        if (this._db.systemData().uuidIndexId() <= 0) {
            return 0L;
        }
        BTree index = this._db.uUIDIndex().getIndex(this._db.systemTransaction());
        return index == null ? 0L : this.bTreeUsage(index);
    }

    private long commitTimestampUsage() {
        LocalTransaction st = (LocalTransaction)this._db.systemTransaction();
        CommitTimestampSupport commitTimestampSupport = st.commitTimestampSupport();
        if (commitTimestampSupport == null) {
            return 0L;
        }
        BTree idToTimestampBtree = commitTimestampSupport.idToTimestamp();
        long idToTimestampBTreeSize = idToTimestampBtree == null ? 0L : this.bTreeUsage(idToTimestampBtree);
        BTree timestampToIdBtree = commitTimestampSupport.timestampToId();
        long timestampToIdBTreeSize = timestampToIdBtree == null ? 0L : this.bTreeUsage(timestampToIdBtree);
        return idToTimestampBTreeSize + timestampToIdBTreeSize;
    }

    private int slotSizeForId(int id) {
        return this.slot(id).length();
    }

    private static <T> T fieldValue(Object parent, String fieldName) {
        return (T)Reflection4.getFieldValue(parent, fieldName);
    }

    private Slot slot(int id) {
        return this._db.idSystem().committedSlot(id);
    }

    private static class InstanceUsage {
        public final long slotUsage;
        public final long miscUsage;

        public InstanceUsage(long slotUsage, long miscUsage) {
            this.slotUsage = slotUsage;
            this.miscUsage = miscUsage;
        }
    }
}

