/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.filestats;

import com.db4o.filestats.ClassUsageStats;
import com.db4o.filestats.FileUsageStatsUtil;
import com.db4o.filestats.SlotMap;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.LongByRef;
import com.db4o.foundation.Tree;
import com.db4o.foundation.TreeNodeIterator;
import com.db4o.foundation.TreeStringObject;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.slots.Slot;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUsageStats {
    private TreeStringObject<ClassUsageStats> _classUsageStats = null;
    private long _fileSize;
    private final long _fileHeader;
    private final long _freespace;
    private final long _idSystem;
    private final long _classMetadata;
    private final long _freespaceUsage;
    private final long _uuidUsage;
    private final long _commitTimestampUsage;
    private final SlotMap _slots;

    FileUsageStats(long fileSize, long fileHeader, long idSystem, long freespace, long classMetadata, long freespaceUsage, long uuidUsage, SlotMap slots, long commitTimestampUsage) {
        this._fileSize = fileSize;
        this._fileHeader = fileHeader;
        this._idSystem = idSystem;
        this._freespace = freespace;
        this._classMetadata = classMetadata;
        this._freespaceUsage = freespaceUsage;
        this._uuidUsage = uuidUsage;
        this._slots = slots;
        this._commitTimestampUsage = commitTimestampUsage;
    }

    public long fileHeader() {
        return this._fileHeader;
    }

    public long freespace() {
        return this._freespace;
    }

    public long idSystem() {
        return this._idSystem;
    }

    public long classMetadata() {
        return this._classMetadata;
    }

    public long freespaceUsage() {
        return this._freespaceUsage;
    }

    public long uuidUsage() {
        return this._uuidUsage;
    }

    public long commitTimestampUsage() {
        return this._commitTimestampUsage;
    }

    public long fileSize() {
        return this._fileSize;
    }

    public long totalUsage() {
        final LongByRef total = new LongByRef(this._fileHeader + this._freespace + this._idSystem + this._classMetadata + this._freespaceUsage + this._uuidUsage + this._commitTimestampUsage);
        Tree.traverse(this._classUsageStats, new Visitor4<TreeStringObject<ClassUsageStats>>(){

            @Override
            public void visit(TreeStringObject<ClassUsageStats> node) {
                total.value += ((ClassUsageStats)node._value).totalUsage();
            }
        });
        return total.value;
    }

    public Iterator<ClassUsageStats> classUsageStats() {
        return Iterators.platformIterator(new TreeNodeIterator(this._classUsageStats));
    }

    public ClassUsageStats classStats(String name) {
        TreeStringObject found = (TreeStringObject)Tree.find(this._classUsageStats, new TreeStringObject<Object>(name, null));
        return found == null ? null : (ClassUsageStats)found._value;
    }

    public String toString() {
        final StringBuffer str = new StringBuffer();
        Tree.traverse(this._classUsageStats, new Visitor4<TreeStringObject<ClassUsageStats>>(){

            @Override
            public void visit(TreeStringObject<ClassUsageStats> node) {
                ((ClassUsageStats)node._value).toString(str);
            }
        });
        str.append("\n");
        str.append(FileUsageStatsUtil.formatLine("File header", this.fileHeader()));
        str.append(FileUsageStatsUtil.formatLine("Freespace", this.freespace()));
        str.append(FileUsageStatsUtil.formatLine("ID system", this.idSystem()));
        str.append(FileUsageStatsUtil.formatLine("Class metadata", this.classMetadata()));
        str.append(FileUsageStatsUtil.formatLine("Freespace usage", this.freespaceUsage()));
        str.append(FileUsageStatsUtil.formatLine("UUID usage", this.uuidUsage()));
        str.append(FileUsageStatsUtil.formatLine("Version usage", this.commitTimestampUsage()));
        str.append("\n");
        long totalUsage = this.totalUsage();
        str.append(FileUsageStatsUtil.formatLine("Total", totalUsage));
        str.append(FileUsageStatsUtil.formatLine("Unaccounted", this.fileSize() - totalUsage));
        str.append(FileUsageStatsUtil.formatLine("File", this.fileSize()));
        str.append(this._slots);
        return str.toString();
    }

    void addClassStats(ClassUsageStats classStats) {
        this._classUsageStats = Tree.add(this._classUsageStats, new TreeStringObject<ClassUsageStats>(classStats.className(), classStats));
    }

    void addSlot(Slot slot) {
        this._slots.add(slot);
    }
}

