/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.filestats;

import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataIterator;
import com.db4o.internal.ClassMetadataRepository;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNode {
    private final ClassMetadata _clazz;
    private final Set<ClassNode> _subClasses = new HashSet<ClassNode>();

    public static Set<ClassNode> buildHierarchy(ClassMetadataRepository repository) {
        ClassMetadataIterator classIter = repository.iterator();
        HashMap<String, ClassNode> nodes = new HashMap<String, ClassNode>();
        HashSet<ClassNode> roots = new HashSet<ClassNode>();
        while (classIter.moveNext()) {
            ClassMetadata clazz = classIter.currentClass();
            ClassNode node = new ClassNode(clazz);
            nodes.put(clazz.getName(), node);
            if (clazz.getAncestor() != null) continue;
            roots.add(node);
        }
        for (ClassNode node : nodes.values()) {
            ClassMetadata ancestor = node.classMetadata().getAncestor();
            if (ancestor == null) continue;
            ((ClassNode)nodes.get(ancestor.getName())).addSubClass(node);
        }
        return roots;
    }

    public ClassNode(ClassMetadata clazz) {
        this._clazz = clazz;
    }

    public ClassMetadata classMetadata() {
        return this._clazz;
    }

    void addSubClass(ClassNode node) {
        this._subClasses.add(node);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this._clazz.getName().equals(((ClassNode)obj)._clazz.getName());
    }

    public int hashCode() {
        return this._clazz.getName().hashCode();
    }

    public Iterable<ClassNode> subClasses() {
        return this._subClasses;
    }
}

