/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.monitoring;

import com.db4o.ObjectServer;
import com.db4o.cs.config.ServerConfiguration;
import com.db4o.cs.config.ServerConfigurationItem;
import com.db4o.cs.internal.ClientConnectionEventArgs;
import com.db4o.cs.internal.ObjectServerEvents;
import com.db4o.cs.internal.ServerClosedEventArgs;
import com.db4o.cs.monitoring.ClientConnections;
import com.db4o.cs.monitoring.Db4oClientServerMBeans;
import com.db4o.events.Event4;
import com.db4o.events.EventListener4;
import com.db4o.events.StringEventArgs;
import com.db4o.ext.Db4oException;
import javax.management.JMException;

public class ClientConnectionsMonitoringSupport
implements ServerConfigurationItem {
    public void apply(ObjectServer server) {
        try {
            final ClientConnections bean = Db4oClientServerMBeans.newClientConnectionsMBean(server);
            bean.register();
            ((ObjectServerEvents)((Object)server)).closed().addListener(new EventListener4<ServerClosedEventArgs>(){

                @Override
                public void onEvent(Event4<ServerClosedEventArgs> e, ServerClosedEventArgs args) {
                    bean.unregister();
                }
            });
            ((ObjectServerEvents)((Object)server)).clientConnected().addListener(new EventListener4<ClientConnectionEventArgs>(){

                @Override
                public void onEvent(Event4<ClientConnectionEventArgs> e, ClientConnectionEventArgs args) {
                    bean.notifyClientConnected();
                }
            });
            ((ObjectServerEvents)((Object)server)).clientDisconnected().addListener(new EventListener4<StringEventArgs>(){

                @Override
                public void onEvent(Event4<StringEventArgs> e, StringEventArgs args) {
                    bean.notifyClientDisconnected();
                }
            });
        }
        catch (JMException exc) {
            throw new Db4oException("Error setting up client connection monitoring support for " + server + ".", exc);
        }
    }

    public void prepare(ServerConfiguration configuration) {
    }
}

