/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal.objectexchange;

import com.db4o.cs.internal.objectexchange.ObjectExchangeConfiguration;
import com.db4o.cs.internal.objectexchange.SlotCollector;
import com.db4o.cs.internal.objectexchange.StandardReferenceCollector;
import com.db4o.cs.internal.objectexchange.StandardSlotAccessor;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.Pair;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.slots.Slot;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EagerObjectWriter {
    private LocalTransaction _transaction;
    private ObjectExchangeConfiguration _config;

    public EagerObjectWriter(ObjectExchangeConfiguration config, LocalTransaction transaction) {
        this._config = config;
        this._transaction = transaction;
    }

    public ByteArrayBuffer write(IntIterator4 idIterator, int maxCount) {
        List<Integer> rootIds = this.readSlots(idIterator, maxCount);
        List<Pair<Integer, Slot>> slots = this.slotsFor(rootIds);
        int marshalledSize = this.marshalledSizeFor(slots) + 4 + rootIds.size() * 4;
        ByteArrayBuffer buffer = new ByteArrayBuffer(marshalledSize);
        this.writeIdSlotPairsTo(slots, buffer);
        this.writeIds(buffer, rootIds);
        return buffer;
    }

    private void writeIds(ByteArrayBuffer buffer, List<Integer> ids) {
        buffer.writeInt(ids.size());
        for (Integer id : ids) {
            buffer.writeInt(id);
        }
    }

    private List<Pair<Integer, Slot>> slotsFor(List<Integer> ids) {
        return new SlotCollector(this._config.prefetchDepth, new StandardReferenceCollector(this._transaction), new StandardSlotAccessor(this._transaction)).collect(Iterators.take(this._config.prefetchCount, Iterators.iterator(ids)));
    }

    private void writeIdSlotPairsTo(List<Pair<Integer, Slot>> slots, ByteArrayBuffer buffer) {
        buffer.writeInt(slots.size());
        for (Pair<Integer, Slot> idSlotPair : slots) {
            int id = (Integer)idSlotPair.first;
            Slot slot = (Slot)idSlotPair.second;
            if (Slot.isNull(slot)) {
                buffer.writeInt(id);
                buffer.writeInt(0);
                continue;
            }
            ByteArrayBuffer slotBuffer = this._transaction.localContainer().readBufferBySlot(slot);
            buffer.writeInt(id);
            buffer.writeInt(slot.length());
            buffer.writeBytes(slotBuffer._buffer);
        }
    }

    private int marshalledSizeFor(List<Pair<Integer, Slot>> slots) {
        int total = 4;
        for (Pair<Integer, Slot> idSlotPair : slots) {
            total += 4;
            total += 4;
            Slot slot = (Slot)idSlotPair.second;
            if (slot == null) continue;
            total += slot.length();
        }
        return total;
    }

    private List<Integer> readSlots(IntIterator4 idIterator, int maxCount) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        while (idIterator.moveNext()) {
            int id = idIterator.currentInt();
            slots.add(id);
            if (slots.size() < maxCount) continue;
            break;
        }
        return slots;
    }
}

