/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal.objectexchange;

import com.db4o.cs.caching.ClientSlotCache;
import com.db4o.cs.internal.ClientTransaction;
import com.db4o.cs.internal.objectexchange.ObjectExchangeStrategy;
import com.db4o.foundation.FixedSizeIntIterator4;
import com.db4o.foundation.IntIterator4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LocalTransaction;

public class DeferredObjectExchangeStrategy
implements ObjectExchangeStrategy {
    public static final ObjectExchangeStrategy INSTANCE = new DeferredObjectExchangeStrategy();

    public ByteArrayBuffer marshall(LocalTransaction transaction, IntIterator4 ids, int count) {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4 + count * 4);
        int sizeOffset = buffer.offset();
        buffer.writeInt(0);
        int written = 0;
        while (count > 0 && ids.moveNext()) {
            buffer.writeInt(ids.currentInt());
            ++written;
            --count;
        }
        buffer.seek(sizeOffset);
        buffer.writeInt(written);
        return buffer;
    }

    public FixedSizeIntIterator4 unmarshall(ClientTransaction transaction, ClientSlotCache slotCache, final ByteArrayBuffer reader) {
        final int size = reader.readInt();
        return new FixedSizeIntIterator4(){
            int _current;
            int _available;
            {
                this._available = size;
            }

            public int size() {
                return size;
            }

            public int currentInt() {
                return this._current;
            }

            public Object current() {
                return this._current;
            }

            public boolean moveNext() {
                if (this._available > 0) {
                    this._current = reader.readInt();
                    --this._available;
                    return true;
                }
                return false;
            }

            public void reset() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

