/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.cs.internal.ClientObjectContainer;
import com.db4o.cs.internal.ClientServerPlatform;
import com.db4o.cs.internal.LazyClientIdIterator;
import com.db4o.cs.internal.messages.Msg;
import com.db4o.cs.internal.messages.MsgD;
import com.db4o.foundation.IntIterator4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.query.result.AbstractQueryResult;

public class LazyClientQueryResult
extends AbstractQueryResult {
    private static final int SIZE_NOT_SET = -1;
    private final ClientObjectContainer _client;
    private final int _queryResultID;
    private int _size = -1;
    private final LazyClientIdIterator _iterator;

    public LazyClientQueryResult(Transaction trans, ClientObjectContainer client, int queryResultID) {
        super(trans);
        this._client = client;
        this._queryResultID = queryResultID;
        this._iterator = new LazyClientIdIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        Object object = this.lock();
        synchronized (object) {
            return this.activatedObject(this.getId(index));
        }
    }

    public int getId(int index) {
        return this.askServer(Msg.OBJECTSET_GET_ID, index);
    }

    public int indexOf(int id) {
        return this.askServer(Msg.OBJECTSET_INDEXOF, id);
    }

    private int askServer(MsgD message, int param) {
        this._client.write(message.getWriterForInts(this._transaction, this._queryResultID, param));
        return ((MsgD)this._client.expectedResponse(message)).readInt();
    }

    public IntIterator4 iterateIDs() {
        return this._iterator;
    }

    public Iterator4 iterator() {
        return ClientServerPlatform.createClientQueryResultIterator(this);
    }

    public int size() {
        if (this._size == -1) {
            this._client.write(Msg.OBJECTSET_SIZE.getWriterForInt(this._transaction, this._queryResultID));
            this._size = ((MsgD)this._client.expectedResponse(Msg.OBJECTSET_SIZE)).readInt();
        }
        return this._size;
    }

    protected void finalize() {
        this._client.write(Msg.OBJECTSET_FINALIZED.getWriterForInt(this._transaction, this._queryResultID));
    }

    public void loadFromIdReader(Iterator4 reader) {
        this._iterator.loadFromIdReader(reader);
    }

    public void reset() {
        this._client.write(Msg.OBJECTSET_RESET.getWriterForInt(this._transaction, this._queryResultID));
    }

    public void fetchIDs(int batchSize) {
        this._client.write(Msg.OBJECTSET_FETCH.getWriterForInts(this._transaction, this._queryResultID, batchSize, this._client.prefetchDepth()));
        ByteArrayBuffer reader = this._client.expectedBufferResponse(Msg.ID_LIST);
        this.loadFromIdReader(this._client.idIteratorFor(this._transaction, reader));
    }
}

