/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.cs.internal;

import com.db4o.DTrace;
import com.db4o.cs.internal.ClientMessageDispatcher;
import com.db4o.cs.internal.ClientObjectContainer;
import com.db4o.cs.internal.Socket4Adapter;
import com.db4o.cs.internal.messages.ClientSideMessage;
import com.db4o.cs.internal.messages.Msg;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.BlockingQueue;
import com.db4o.internal.Transaction;

class ClientMessageDispatcherImpl
implements Runnable,
ClientMessageDispatcher {
    private ClientObjectContainer _container;
    private Socket4Adapter _socket;
    private final BlockingQueue _synchronousMessageQueue;
    private final BlockingQueue _asynchronousMessageQueue;
    private boolean _isClosed;

    ClientMessageDispatcherImpl(ClientObjectContainer client, Socket4Adapter a_socket, BlockingQueue synchronousMessageQueue, BlockingQueue asynchronousMessageQueue) {
        this._container = client;
        this._synchronousMessageQueue = synchronousMessageQueue;
        this._asynchronousMessageQueue = asynchronousMessageQueue;
        this._socket = a_socket;
    }

    public synchronized boolean isMessageDispatcherAlive() {
        return !this._isClosed;
    }

    public synchronized boolean close() {
        if (this._isClosed) {
            return true;
        }
        this._isClosed = true;
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (Db4oIOException db4oIOException) {
                // empty catch block
            }
        }
        this._synchronousMessageQueue.stop();
        this._asynchronousMessageQueue.stop();
        return true;
    }

    public void run() {
        this.messageLoop();
        this.close();
    }

    public void messageLoop() {
        while (this.isMessageDispatcherAlive()) {
            Msg message = null;
            try {
                message = Msg.readMessage(this, this.transaction(), this._socket);
            }
            catch (Db4oIOException exc) {
                if (DTrace.enabled) {
                    DTrace.CLIENT_MESSAGE_LOOP_EXCEPTION.log(exc.toString());
                }
                return;
            }
            if (message == null) continue;
            if (this.isClientSideMessage(message)) {
                this._asynchronousMessageQueue.add(message);
                continue;
            }
            this._synchronousMessageQueue.add(message);
        }
    }

    private boolean isClientSideMessage(Msg message) {
        return message instanceof ClientSideMessage;
    }

    public boolean write(Msg msg) {
        this._container.write(msg);
        return true;
    }

    private Transaction transaction() {
        return this._container.transaction();
    }
}

