/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.constraints;

import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.constraints.UniqueFieldValueConstraintViolationException;
import com.db4o.events.CommitEventArgs;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistryFactory;
import com.db4o.ext.ObjectInfo;
import com.db4o.ext.ObjectInfoCollection;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.core.ReflectorUtils;

public class UniqueFieldValueConstraint
implements ConfigurationItem {
    protected final Object _clazz;
    protected final String _fieldName;

    public UniqueFieldValueConstraint(Object clazz, String fieldName) {
        this._clazz = clazz;
        this._fieldName = fieldName;
    }

    public void prepare(Configuration configuration) {
    }

    public void apply(final InternalObjectContainer objectContainer) {
        if (objectContainer.isClient()) {
            throw new IllegalStateException(this.getClass().getName() + " should be configured on the server.");
        }
        EventRegistryFactory.forObjectContainer(objectContainer).committing().addListener(new EventListener4(){
            private FieldMetadata _fieldMetaData;

            private void ensureSingleOccurence(Transaction trans, ObjectInfoCollection col) {
                Iterator4 i = col.iterator();
                while (i.moveNext()) {
                    BTreeRange range;
                    ObjectInfo objectInfo = (ObjectInfo)i.current();
                    if (this.reflectClass() != UniqueFieldValueConstraint.this.reflectorFor(trans, objectInfo.getObject())) continue;
                    Object obj = this.objectFor(trans, objectInfo);
                    Object fieldValue = this.fieldMetadata().getOn(trans, obj);
                    if (fieldValue == null || (range = this.fieldMetadata().search(trans, fieldValue)).size() <= 1) continue;
                    throw new UniqueFieldValueConstraintViolationException(this.classMetadata().getName(), this.fieldMetadata().getName());
                }
            }

            private boolean isClassMetadataAvailable() {
                return null != this.classMetadata();
            }

            private FieldMetadata fieldMetadata() {
                if (this._fieldMetaData != null) {
                    return this._fieldMetaData;
                }
                this._fieldMetaData = this.classMetadata().fieldMetadataForName(UniqueFieldValueConstraint.this._fieldName);
                return this._fieldMetaData;
            }

            private ClassMetadata classMetadata() {
                return objectContainer.classMetadataForReflectClass(this.reflectClass());
            }

            private ReflectClass reflectClass() {
                return ReflectorUtils.reflectClassFor(objectContainer.reflector(), UniqueFieldValueConstraint.this._clazz);
            }

            public void onEvent(Event4 e, EventArgs args) {
                if (!this.isClassMetadataAvailable()) {
                    return;
                }
                CommitEventArgs commitEventArgs = (CommitEventArgs)args;
                Transaction trans = (Transaction)commitEventArgs.transaction();
                this.ensureSingleOccurence(trans, commitEventArgs.added());
                this.ensureSingleOccurence(trans, commitEventArgs.updated());
            }

            private Object objectFor(Transaction trans, ObjectInfo info) {
                int id = (int)info.getInternalID();
                HardObjectReference ref = HardObjectReference.peekPersisted(trans, id, 1);
                return ref._object;
            }
        });
    }

    private ReflectClass reflectorFor(Transaction trans, Object obj) {
        return trans.container().reflector().forObject(obj);
    }
}

