/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.consistency;

import com.db4o.consistency.OverlapMap;
import com.db4o.consistency.SlotDetail;
import com.db4o.foundation.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistencyReport {
    private static final int MAX_REPORTED_ITEMS = 50;
    final List<SlotDetail> bogusSlots;
    final OverlapMap overlaps;
    final List<Pair<String, Integer>> invalidObjectIds;
    final List<Pair<String, Integer>> invalidFieldIndexEntries;

    ConsistencyReport(List<SlotDetail> bogusSlots, OverlapMap overlaps, List<Pair<String, Integer>> invalidClassIds, List<Pair<String, Integer>> invalidFieldIndexEntries) {
        this.bogusSlots = bogusSlots;
        this.overlaps = overlaps;
        this.invalidObjectIds = invalidClassIds;
        this.invalidFieldIndexEntries = invalidFieldIndexEntries;
    }

    public boolean consistent() {
        return this.bogusSlots.size() == 0 && this.overlaps.overlaps().size() == 0 && this.overlaps.dupes().size() == 0 && this.invalidObjectIds.size() == 0 && this.invalidFieldIndexEntries.size() == 0;
    }

    public Set<Pair<SlotDetail, SlotDetail>> overlaps() {
        return this.overlaps.overlaps();
    }

    public Set<Pair<SlotDetail, SlotDetail>> dupes() {
        return this.overlaps.dupes();
    }

    public String toString() {
        if (this.consistent()) {
            return "no inconsistencies detected";
        }
        StringBuffer message = new StringBuffer("INCONSISTENCIES DETECTED\n").append(this.overlaps.overlaps().size() + " overlaps\n").append(this.overlaps.dupes().size() + " dupes\n").append(this.bogusSlots.size() + " bogus slots\n").append(this.invalidObjectIds.size() + " invalid class ids\n").append(this.invalidFieldIndexEntries.size() + " invalid field index entries\n");
        message.append("(slot lengths are non-blocked)\n");
        this.appendInconsistencyReport(message, "OVERLAPS", this.overlaps.overlaps());
        this.appendInconsistencyReport(message, "DUPES", this.overlaps.dupes());
        this.appendInconsistencyReport(message, "BOGUS SLOTS", this.bogusSlots);
        this.appendInconsistencyReport(message, "INVALID OBJECT IDS", this.invalidObjectIds);
        this.appendInconsistencyReport(message, "INVALID FIELD INDEX ENTRIES", this.invalidFieldIndexEntries);
        return message.toString();
    }

    private <T> void appendInconsistencyReport(StringBuffer str, String title, Collection<T> entries) {
        if (entries.size() != 0) {
            str.append(title + "\n");
            int count = 0;
            for (T entry : entries) {
                str.append(entry).append("\n");
                if (++count <= 50) continue;
                str.append("and more...\n");
                break;
            }
        }
    }
}

