/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.config.annotations.reflect;

import com.db4o.config.Configuration;
import com.db4o.config.annotations.CalledConstructor;
import com.db4o.config.annotations.GeneratedUUIDs;
import com.db4o.config.annotations.Indexed;
import com.db4o.config.annotations.PersistedStaticFieldValues;
import com.db4o.config.annotations.StoredTransientFields;
import com.db4o.config.annotations.UpdatedDepth;
import com.db4o.config.annotations.reflect.CalledConstructorFactory;
import com.db4o.config.annotations.reflect.Db4oConfigurator;
import com.db4o.config.annotations.reflect.Db4oConfiguratorFactory;
import com.db4o.config.annotations.reflect.GeneratedUUIDsFactory;
import com.db4o.config.annotations.reflect.IndexedConfigurator;
import com.db4o.config.annotations.reflect.NoArgsFieldConfiguratorFactory;
import com.db4o.config.annotations.reflect.PersistedStaticFieldValuesFactory;
import com.db4o.config.annotations.reflect.StoredTransientFieldsFactory;
import com.db4o.config.annotations.reflect.UpdatedDepthFactory;
import com.db4o.internal.Config4Class;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationIntrospector {
    Map<Class<? extends Annotation>, Db4oConfiguratorFactory> _configurators;
    Config4Class _classConfig;
    Class _clazz;
    Configuration _config;

    public ConfigurationIntrospector(Class clazz, Configuration config, Config4Class classConfig) throws Exception {
        this._classConfig = classConfig;
        this._clazz = clazz;
        this._config = config;
        this.initMap();
    }

    private void initMap() throws NoSuchMethodException {
        this._configurators = new HashMap<Class<? extends Annotation>, Db4oConfiguratorFactory>();
        this._configurators.put(UpdatedDepth.class, new UpdatedDepthFactory());
        this._configurators.put(Indexed.class, new NoArgsFieldConfiguratorFactory(IndexedConfigurator.class));
        this._configurators.put(CalledConstructor.class, new CalledConstructorFactory());
        this._configurators.put(GeneratedUUIDs.class, new GeneratedUUIDsFactory());
        this._configurators.put(StoredTransientFields.class, new StoredTransientFieldsFactory());
        this._configurators.put(PersistedStaticFieldValues.class, new PersistedStaticFieldValuesFactory());
    }

    public Config4Class apply() {
        try {
            this.reflectClass();
            this.reflectFields();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return this._classConfig;
    }

    private void reflectClass() {
        Annotation[] annotations;
        for (Annotation a : annotations = this._clazz.getAnnotations()) {
            this.applyAnnotation(this._clazz, a);
        }
    }

    private void reflectFields() {
        try {
            Field[] declaredFields;
            for (Field f : declaredFields = this._clazz.getDeclaredFields()) {
                for (Annotation a : f.getAnnotations()) {
                    this.applyAnnotation(f, a);
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private void applyAnnotation(AnnotatedElement element, Annotation a) {
        if (this._configurators.containsKey(a.annotationType())) {
            Db4oConfigurator configurator = this._configurators.get(a.annotationType()).configuratorFor(element, a);
            this._classConfig = (Config4Class)configurator.configure(this._config);
        }
    }
}

