/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.jdk;

import com.db4o.reflect.ReflectArray;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.jdk.JdkArray;
import com.db4o.reflect.jdk.JdkClass;

public class JdkReflector
implements Reflector {
    private final ClassLoader _classLoader;
    private Reflector _parent;
    private ReflectArray _array;

    public JdkReflector(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public ReflectArray array() {
        if (this._array == null) {
            this._array = new JdkArray(this._parent);
        }
        return this._array;
    }

    public boolean constructorCallsSupported() {
        return true;
    }

    public Object deepClone(Object object) {
        return new JdkReflector(this._classLoader);
    }

    public ReflectClass forClass(Class clazz) {
        return new JdkClass(this._parent, clazz);
    }

    public ReflectClass forName(String string) {
        try {
            Class<?> clazz;
            Class<?> clazz2 = clazz = this._classLoader == null ? Class.forName(string) : this._classLoader.loadClass(string);
            if (clazz == null) {
                return null;
            }
            return new JdkClass(this._parent, clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ReflectClass forObject(Object object) {
        if (object == null) {
            return null;
        }
        return this._parent.forClass(object.getClass());
    }

    public boolean isCollection(ReflectClass reflectClass) {
        return false;
    }

    public boolean methodCallsSupported() {
        return true;
    }

    public void setParent(Reflector reflector) {
        this._parent = reflector;
    }

    public static ReflectClass[] toMeta(Reflector reflector, Class[] classArray) {
        ReflectClass[] reflectClassArray = null;
        if (classArray != null) {
            reflectClassArray = new ReflectClass[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == null) continue;
                reflectClassArray[i] = reflector.forClass(classArray[i]);
            }
        }
        return reflectClassArray;
    }

    static Class[] toNative(ReflectClass[] reflectClassArray) {
        Class[] classArray = null;
        if (reflectClassArray != null) {
            classArray = new Class[reflectClassArray.length];
            for (int i = 0; i < reflectClassArray.length; ++i) {
                classArray[i] = JdkReflector.toNative(reflectClassArray[i]);
            }
        }
        return classArray;
    }

    public static Class toNative(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return null;
        }
        if (reflectClass instanceof JdkClass) {
            return ((JdkClass)reflectClass).getJavaClass();
        }
        ReflectClass reflectClass2 = reflectClass.getDelegate();
        if (reflectClass2 == reflectClass) {
            return null;
        }
        return JdkReflector.toNative(reflectClass2);
    }
}

