/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import java.io.IOException;

public abstract class IoAdapter {
    private static final int COPY_SIZE = 4096;
    private int _blockSize;

    protected final long regularAddress(int n, int n2) {
        return (long)n * (long)this._blockSize + (long)n2;
    }

    public void blockCopy(int n, int n2, int n3, int n4, int n5) throws IOException {
        this.copy(this.regularAddress(n, n2), this.regularAddress(n3, n4), n5);
    }

    public void blockSeek(int n) throws IOException {
        this.blockSeek(n, 0);
    }

    public void blockSeek(int n, int n2) throws IOException {
        this.seek(this.regularAddress(n, n2));
    }

    public void blockSize(int n) {
        this._blockSize = n;
    }

    public abstract void close() throws IOException;

    public void copy(long l, long l2, int n) throws IOException {
        if (n > 4096) {
            byte[] byArray = new byte[4096];
            int n2 = 0;
            while (n2 + 4096 < n) {
                this.copy(byArray, l + (long)n2, l2 + (long)n2);
                n2 += 4096;
            }
            l += (long)n2;
            l2 += (long)n2;
            n -= n2;
        }
        this.copy(new byte[n], l, l2);
    }

    private void copy(byte[] byArray, long l, long l2) throws IOException {
        this.seek(l);
        this.read(byArray);
        this.seek(l2);
        this.write(byArray);
    }

    public abstract void delete(String var1);

    public abstract boolean exists(String var1);

    public abstract long getLength() throws IOException;

    public abstract IoAdapter open(String var1, boolean var2, long var3) throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, byArray.length);
    }

    public abstract int read(byte[] var1, int var2) throws IOException;

    public abstract void seek(long var1) throws IOException;

    public abstract void sync() throws IOException;

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, byArray.length);
    }

    public abstract void write(byte[] var1, int var2) throws IOException;

    public int blockSize() {
        return this._blockSize;
    }
}

