/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.freespace;

import com.db4o.MetaIndex;
import com.db4o.Tree;
import com.db4o.YapFile;
import com.db4o.YapReader;
import com.db4o.YapWriter;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.IntObjectVisitor;
import com.db4o.foundation.Visitor4;
import com.db4o.inside.freespace.FreespaceIxAddress;
import com.db4o.inside.freespace.FreespaceIxLength;
import com.db4o.inside.freespace.FreespaceManager;
import com.db4o.inside.ix.IxTree;

public class FreespaceManagerIx
extends FreespaceManager {
    private int _slotAddress;
    private FreespaceIxAddress _addressIx;
    private FreespaceIxLength _lengthIx;
    private boolean _started;
    private Collection4 _xBytes;

    FreespaceManagerIx(YapFile yapFile) {
        super(yapFile);
    }

    private void add(int n, int n2) {
        this._addressIx.add(n, n2);
        this._lengthIx.add(n, n2);
    }

    public void beginCommit() {
        if (!this.started()) {
            return;
        }
        FreespaceManagerIx.slotEntryToZeroes(this._file, this._slotAddress);
    }

    public void debug() {
    }

    public void endCommit() {
        if (!this.started()) {
            return;
        }
        this._addressIx._index.commitFreeSpace(this._lengthIx._index);
        YapWriter yapWriter = new YapWriter(this._file.getSystemTransaction(), this._slotAddress, FreespaceManagerIx.slotLength());
        this._addressIx._index._metaIndex.write(yapWriter);
        this._lengthIx._index._metaIndex.write(yapWriter);
        if (this._file.i_config.flushFileBuffers()) {
            this._file.syncFiles();
        }
        yapWriter.writeEncrypt();
    }

    public void free(int n, int n2) {
        if (!this.started()) {
            return;
        }
        if (n <= 0) {
            return;
        }
        if (n2 <= this.discardLimit()) {
            return;
        }
        n2 = this._file.blocksFor(n2);
        int n3 = n;
        int n4 = n2;
        this._addressIx.find(n);
        if (this._addressIx.preceding() && this._addressIx.address() + this._addressIx.length() == n) {
            this.remove(this._addressIx.address(), this._addressIx.length());
            n = this._addressIx.address();
            n2 += this._addressIx.length();
            this._addressIx.find(n3);
        }
        if (this._addressIx.subsequent() && n3 + n4 == this._addressIx.address()) {
            this.remove(this._addressIx.address(), this._addressIx.length());
            n2 += this._addressIx.length();
        }
        this.add(n, n2);
    }

    public void freeSelf() {
        if (!this.started()) {
            return;
        }
        this._addressIx._index._metaIndex.free(this._file);
        this._lengthIx._index._metaIndex.free(this._file);
    }

    public int getSlot(int n) {
        if (!this.started()) {
            return 0;
        }
        int n2 = this.getSlot1(n);
        if (n2 != 0) {
            // empty if block
        }
        return n2;
    }

    private int getSlot1(int n) {
        if (!this.started()) {
            return 0;
        }
        n = this._file.blocksFor(n);
        this._lengthIx.find(n);
        if (this._lengthIx.match()) {
            this.remove(this._lengthIx.address(), this._lengthIx.length());
            return this._lengthIx.address();
        }
        if (this._lengthIx.subsequent()) {
            int n2 = this._lengthIx.length() - n;
            int n3 = this._lengthIx.address() + n;
            this.remove(this._lengthIx.address(), this._lengthIx.length());
            this.add(n3, n2);
            return this._lengthIx.address();
        }
        return 0;
    }

    public void migrate(final FreespaceManager freespaceManager) {
        if (!this.started()) {
            return;
        }
        final IntObjectVisitor intObjectVisitor = new IntObjectVisitor(){

            public void visit(int n, Object object) {
                freespaceManager.free((Integer)object, n);
            }
        };
        Tree.traverse(this._addressIx._indexTrans.getRoot(), new Visitor4(){

            public void visit(Object object) {
                IxTree ixTree = (IxTree)object;
                ixTree.visitAll(intObjectVisitor);
            }
        });
    }

    public void read(int n) {
    }

    private void remove(int n, int n2) {
        this._addressIx.remove(n, n2);
        this._lengthIx.remove(n, n2);
    }

    public void start(int n) {
        if (this.started()) {
            return;
        }
        this._slotAddress = n;
        MetaIndex metaIndex = new MetaIndex();
        MetaIndex metaIndex2 = new MetaIndex();
        YapReader yapReader = new YapReader(FreespaceManagerIx.slotLength());
        yapReader.read(this._file, n, 0);
        metaIndex.read(yapReader);
        metaIndex2.read(yapReader);
        this._addressIx = new FreespaceIxAddress(this._file, metaIndex);
        this._lengthIx = new FreespaceIxLength(this._file, metaIndex2);
        this._started = true;
    }

    private boolean started() {
        return this._started;
    }

    public byte systemType() {
        return 3;
    }

    public int write(boolean bl) {
        return 0;
    }

    private void writeXBytes(int n, int n2) {
    }
}

