/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.inside.btree;

import com.db4o.Transaction;
import com.db4o.foundation.No4;
import com.db4o.inside.btree.BTree;

public abstract class BTreePatch {
    protected BTreePatch _previous;
    protected BTreePatch _next;
    protected final Transaction _transaction;
    final Object _object;

    public BTreePatch(Transaction transaction, Object object) {
        this._transaction = transaction;
        this._object = object;
    }

    public BTreePatch append(BTreePatch bTreePatch) {
        if (this._transaction == bTreePatch._transaction) {
            bTreePatch._next = this._next;
            return bTreePatch;
        }
        this._next = this._next == null ? bTreePatch : this._next.append(bTreePatch);
        return this;
    }

    public Object commit(Transaction transaction, BTree bTree) {
        return this.commit(transaction, bTree, true);
    }

    private Object commit(Transaction transaction, BTree bTree, boolean bl) {
        if (this._transaction == transaction) {
            if (this._next != null) {
                return this._next;
            }
            return this.committed(bTree);
        }
        if (this._next != null) {
            Object object = this._next.commit(transaction, bTree, false);
            this._next = object instanceof BTreePatch ? (BTreePatch)object : null;
        }
        return this;
    }

    protected abstract Object committed(BTree var1);

    public BTreePatch forTransaction(Transaction transaction) {
        if (this._transaction == transaction) {
            return this;
        }
        if (this._next == null) {
            return null;
        }
        return this._next.forTransaction(transaction);
    }

    public Object getObject(Transaction transaction) {
        BTreePatch bTreePatch = this.forTransaction(transaction);
        if (bTreePatch == null) {
            return No4.INSTANCE;
        }
        return bTreePatch.getObject();
    }

    protected abstract Object getObject();

    public Object rollback(Transaction transaction, BTree bTree) {
        return this.rollback(transaction, bTree, true);
    }

    public Object rollback(Transaction transaction, BTree bTree, boolean bl) {
        if (this._transaction == transaction) {
            if (this._next != null) {
                return this._next;
            }
            return this.rolledBack(bTree);
        }
        if (this._next != null) {
            Object object = this._next.rollback(transaction, bTree, false);
            this._next = object instanceof BTreePatch ? (BTreePatch)object : null;
        }
        return this;
    }

    protected abstract Object rolledBack(BTree var1);

    public String toString() {
        if (this._object == null) {
            return "[NULL]";
        }
        return this._object.toString();
    }
}

